/* 
 * Copyright 2013 ClinRisk Ltd.
 * 
 * This file is part of QRISK2-2013 (http://qrisk.org, http://svn.clinrisk.co.uk/opensource/qrisk2).
 * 
 * QRISK2-2013 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * QRISK2-2013 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with QRISK2-2013.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Additional terms
 * 
 * The following disclaimer must be displayed alongside any risk score generated by this code.
 *   The initial version of this file, to be found at http://svn.clinrisk.co.uk/opensource/qrisk2, faithfully implements QRISK2-2013.
 *   We have released this code under the GNU Lesser General Public License to enable others to implement the algorithm faithfully.
 *   However, the nature of the GNU Lesser General Public License is such that we cannot prevent, for example, someone accidentally 
 *   altering the coefficients, getting the inputs wrong, or just poor programming.
 *   We stress, therefore, that it is the responsibility of the end user to check that the source that they receive produces the same results as the original code posted at http://svn.clinrisk.co.uk/opensource/qrisk2.
 *   Inaccurate implementations of risk scores can lead to wrong patients being given the wrong treatment.
 * 
 * This file has been auto-generated.
 * XML source: Q77_qrisk2_2013_0.xml
 * STATA dta time stamp: 16 Nov 2012 22:10
 * This file was created on: Wed  8 May 2013 07:41:31 BST
 */

#include <math.h>
#include <string.h>
#include <clinrisk/Q77_qrisk2_2013_0.h>
#include <clinrisk/utils.h>

static double cvd_female_raw(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town
)
{
	double survivor[16] = {
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0.988779306411743,
		0,
		0,
		0,
		0,
		0
	};

	/* The conditional arrays */

	double Iethrisk[10] = {
		0,
		0,
		0.3247649848349589700000000,
		0.6490919016600146300000000,
		0.3225960666395069100000000,
		-0.0698843828816220060000000,
		-0.0526174237973003890000000,
		-0.3583620628676293400000000,
		-0.4631969844038496000000000,
		-0.0934620942542618430000000
	};
	double Ismoke[5] = {
		0,
		0.2325777856801529700000000,
		0.5540189636820945800000000,
		0.6903408593375299800000000,
		0.8853278749891940700000000
	};

	/* Applying the fractional polynomial transforms */
	/* (which includes scaling)                      */

	double dage = age;
	dage=dage/10;
	double age_1 = pow(dage,.5);
	double age_2 = dage;
	double dbmi = bmi;
	dbmi=dbmi/10;
	double bmi_1 = pow(dbmi,-2);
	double bmi_2 = pow(dbmi,-2)*log(dbmi);

	/* Centring the continuous variables */

	age_1 = age_1 - 2.111304044723511;
	age_2 = age_2 - 4.457604408264160;
	bmi_1 = bmi_1 - 0.153318107128143;
	bmi_2 = bmi_2 - 0.143754154443741;
	rati = rati - 3.597785472869873;
	sbp = sbp - 126.525978088378910;
	town = town - -0.099030286073685;

	/* Start of Sum */
	double a=0;

	/* The conditional sums */

	a += Iethrisk[ethrisk];
	a += Ismoke[smoke_cat];

	/* Sum from continuous values */

	a += age_1 * 4.1924277678057837000000000;
	a += age_2 * 0.0727365264473135150000000;
	a += bmi_1 * -0.4914322358663353900000000;
	a += bmi_2 * -2.9736893891126503000000000;
	a += rati * 0.1456741893144524700000000;
	a += sbp * 0.0124301977948376370000000;
	a += town * 0.0638839291971372570000000;

	/* Sum from boolean values */

	a += b_AF * 1.2548823570386274000000000;
	a += b_ra * 0.3660166445401525400000000;
	a += b_renal * 0.8000369779764396900000000;
	a += b_treatedhyp * 0.6183822524814552900000000;
	a += b_type1 * 1.7623106103850039000000000;
	a += b_type2 * 1.0714795465634313000000000;
	a += fh_cvd * 0.6138914873273221300000000;

	/* Sum from interaction terms */

	a += age_1 * (smoke_cat==1) * 1.5288149154981097000000000;
	a += age_1 * (smoke_cat==2) * 1.8932677924373249000000000;
	a += age_1 * (smoke_cat==3) * -0.2120377720167573300000000;
	a += age_1 * (smoke_cat==4) * -1.8022626575074350000000000;
	a += age_1 * b_AF * -2.0489636167088636000000000;
	a += age_1 * b_renal * 2.1378812069259072000000000;
	a += age_1 * b_treatedhyp * -3.9467205554873872000000000;
	a += age_1 * b_type1 * 5.0295952006040174000000000;
	a += age_1 * b_type2 * -4.1006039491910871000000000;
	a += age_1 * bmi_1 * 15.6869018580842020000000000;
	a += age_1 * bmi_2 * 10.5172051502483440000000000;
	a += age_1 * fh_cvd * 0.1788021490217178200000000;
	a += age_1 * sbp * 0.0035841283715529319000000;
	a += age_1 * town * 0.2643549142624118100000000;
	a += age_2 * (smoke_cat==1) * -0.3515526357562532800000000;
	a += age_2 * (smoke_cat==2) * -0.4673806143887411200000000;
	a += age_2 * (smoke_cat==3) * -0.0520627514443069360000000;
	a += age_2 * (smoke_cat==4) * 0.2408148624618006200000000;
	a += age_2 * b_AF * 0.1989800041198926100000000;
	a += age_2 * b_renal * -0.5666471358116902400000000;
	a += age_2 * b_treatedhyp * 0.6659359807539360100000000;
	a += age_2 * b_type1 * -1.3790306447153591000000000;
	a += age_2 * b_type2 * 0.6477002677213917800000000;
	a += age_2 * bmi_1 * -3.0654336861574962000000000;
	a += age_2 * bmi_2 * -1.0265341871793443000000000;
	a += age_2 * fh_cvd * -0.1598294041246048900000000;
	a += age_2 * sbp * -0.0037836254753488216000000;
	a += age_2 * town * -0.0731237907079357600000000;

	/* Calculate the score itself */
	double score = 100.0 * (1 - pow(survivor[surv], exp(a)) );
	return score;
}

static int cvd_female_validation(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,char *errorBuf,int errorBufSize
)
{
	int ok=1;
	*errorBuf=0;
	if (!i_in_range(age,25,84)) {
		ok=0;
		strlcat(errorBuf,"error: age must be in range (25,84)\n",errorBufSize);
	}
	if (!is_boolean(b_AF)) {
		ok=0;
		strlcat(errorBuf,"error: b_AF must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_ra)) {
		ok=0;
		strlcat(errorBuf,"error: b_ra must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_renal)) {
		ok=0;
		strlcat(errorBuf,"error: b_renal must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_treatedhyp)) {
		ok=0;
		strlcat(errorBuf,"error: b_treatedhyp must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type1)) {
		ok=0;
		strlcat(errorBuf,"error: b_type1 must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type2)) {
		ok=0;
		strlcat(errorBuf,"error: b_type2 must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(bmi,20,40)) {
		ok=0;
		strlcat(errorBuf,"error: bmi must be in range (20,40)\n",errorBufSize);
	}
	if (!i_in_range(ethrisk,1,9)) {
		ok=0;
		strlcat(errorBuf,"error: ethrisk must be in range (1,9)\n",errorBufSize);
	}
	if (!is_boolean(fh_cvd)) {
		ok=0;
		strlcat(errorBuf,"error: fh_cvd must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(rati,1,12)) {
		ok=0;
		strlcat(errorBuf,"error: rati must be in range (1,12)\n",errorBufSize);
	}
	if (!d_in_range(sbp,70,210)) {
		ok=0;
		strlcat(errorBuf,"error: sbp must be in range (70,210)\n",errorBufSize);
	}
	if (!i_in_range(smoke_cat,0,4)) {
		ok=0;
		strlcat(errorBuf,"error: smoke_cat must be in range (0,4)\n",errorBufSize);
	}
	if (surv!=10) {
		ok=0;
		strlcat(errorBuf,"error: surv must be 10\n",errorBufSize);
	}
	if (!d_in_range(town,-7,11)) {
		ok=0;
		strlcat(errorBuf,"error: town must be in range (-7,11)\n",errorBufSize);
	}
	return ok;
}

double cvd_female(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,int *error,char *errorBuf,int errorBufSize
)
{
	*error = 0;	int ok = cvd_female_validation(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town,errorBuf,errorBufSize);
	if(!ok) { 
		*error = 1;
		return 0.0;
	}
	return cvd_female_raw(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town);
}
