#ifndef SYNTHES_H
#define SYNTHES_H
#include <math.h>




#define SINTABLEN 1024


#ifndef SYNTHESLOCAL
extern short int sinTab[SINTABLEN];
extern float oldAngle;


void sinTabGen();

/*
  To generate the frequency, we have to calculate the instant phase jump of the signal
  by dividing the frequency by the SR.
  We multiply this by the number of entries in the sine lookup table.
  This value is added to the old index  of the sine table.
*/

static __inline__ short int nextSample(int freq)
{
  float temp;
  int t;
  short int i;
  temp=((float)freq/fTXsamplingrate)*(float)SINTABLEN+oldAngle;
  oldAngle=fmod(temp,SINTABLEN);
  t=(int)(oldAngle+0.5);
  //t=(int)(oldAngle);
  i=sinTab[t%SINTABLEN];
  return i;
}

static __inline__ void initSynthes()
{
  oldAngle=0;
  sinTabGen();
}

#endif
#endif







