/***************************************************************************
                          thumbwindow.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "thumbwindow.h"
#include "qsstvglobal.h"
#include <qstring.h>
#include "filefunc.h"
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qwhatsthis.h>
#include <qlabel.h>
#include "ctext.h"


#include "cpixmap.h"
thumbWindow::thumbWindow(QWidget *p ,const char *n, WFlags f):QMainWindow( p,n,f)
{
  int i,j;
  QFileInfo t;
  canvas=new QFrame(this);
  setCentralWidget(canvas);
  thumbLayout = new QGridLayout( canvas, THUMBROWS, THUMBCOLUMS, 2, 2, NULL );
  for (i=0;i<THUMBCOLUMS;i++)
    {
      thumbLayout->addColSpacing( i, 2 );
      thumbLayout->setColStretch( i, 1 ); 
    }
  for (i=0;i<THUMBROWS;i++)
    {
      thumbLayout->addRowSpacing( i, 0 );
      thumbLayout->setRowStretch( i, 1 );
      for (j=0;j<THUMBCOLUMS;j++)
	{
	  thumbArray[i][j] = new thumbFrame(canvas,i,j);
	  thumbLayout->addColSpacing( i, 2 );
	  thumbLayout->setColStretch( i, 1 );
	  thumbLayout->addWidget( thumbArray[i][j], i, j, 0 );
	}
    }
  colIdx=0;rowIdx=0;
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c1")));
  if (t.isFile())  add(t.filePath());
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c2")));
  if (t.isFile())  add(t.filePath());
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c3")));
  if (t.isFile())  add(t.filePath());
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c4")));
  if (t.isFile())  add(t.filePath());
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c5")));
  if (t.isFile())  add(t.filePath());
  fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption("Thumbnailr1c6")));
  if (t.isFile()) add(t.filePath());
  colIdx=0;rowIdx=1;
  firstRow=1;
  firstCol=0;


  statusBar()->message( "Ready");
  resize (300,200);
}



thumbWindow::~thumbWindow()
{
 int i,j;
 for (i=0;i<THUMBROWS;i++)
    {
      for (j=0;j<THUMBCOLUMS;j++)
	{
	  delete thumbArray[i][j];
	}
    }
}

void thumbWindow::setCanvas(imageFrame *c)
{
  int i,j;
  for (i=0;i<THUMBROWS;i++)
    {
      for (j=0;j<THUMBCOLUMS;j++)
	{
	  thumbArray[i][j]->setCanvas(c);;
	}
    }
}

void thumbWindow::next()
{
  colIdx++;
  if (colIdx>=THUMBCOLUMS)
    {
      colIdx=0;
      rowIdx++;
      if (rowIdx>=THUMBROWS)
	{
	  rowIdx=firstRow;
	  colIdx=firstCol;
	}
    }
}

QFileInfo *thumbWindow::getLatest()
{
  int ci=colIdx;
  int ri=rowIdx;

  ci--;
  if (ci<0)
    {
      ci=THUMBCOLUMS-1;
      ri--;
      if (ri<firstRow)
	{
	  ri=THUMBROWS-1;
	}
    }
  return(thumbArray[ri][ci]->getFilename());
}


void thumbWindow::add(QFileInfo fn)
{ 
 thumbArray[rowIdx][colIdx]->load(fn);
 next();
}

void thumbWindow::closeEvent(QCloseEvent *e)
{
  e->ignore();
}




