/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qapplication.h>

#include "syntp.h"

#include <map>
#include <string>
#include <iostream>


//
// main widget
//
#include "myqsdlg.h"


int main(int argc, char *argv[]) {
    int i;
    std::map<std::string,int> param;
    
    // parameter treatment - must be happening before the Qt Widgets get instanciated!
    for (i=0;i<argc;i++)
        param[std::string(argv[i])]=i;
    
            
    if ( (param.find("-h")!=param.end()) | (param.find("--help")!=param.end()) )
    {
        std::cout<<" - usage:"<<std::endl;
        std::cout<<"  --help / -h : prints this help message"<< std::endl;
        std::cout<<"  --restore / -r : restores saved parameter settings from ~/.qsynaptics"<< std::endl; 
        
        exit(1);
    }
    
    if ( (param.find("-r")!=param.end()) | (param.find("--restore")!=param.end()) )
    {
        std::cout<<"restoring saved parameter settings from ~/.qsynaptics"<<std::endl;
        
        SynTouchPad myTP;
        myTP.restoreConfig();
        myTP.applyAndStoreConfig();
        
        exit(2);
    }

    // start off with the QT specific stuff
    QApplication myApp(argc,argv);
    myApp.setFont(QFont("Helvetica",10));

    myQsDlg myDlg;

    // preparation
    myApp.setMainWidget(&myDlg);
    myDlg.show();

    // run the application
    return myApp.exec();
}
