/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "config.h"

#include "qtadsdialog.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>


QTadsDialog::QTadsDialog( const QString& text, QWidget* parent, const char* name, WFlags f )
: QDialog(parent, name, true, f), fButtonCount(0)
{
	this->setSizeGripEnabled(true);
	this->fMainLayout = new QVBoxLayout(this, 11, 6);
	this->fUpperLayout = new QHBoxLayout(this->fMainLayout);
	this->fButtonLayout = new QHBoxLayout(this->fMainLayout);
	this->fText = new QLabel(this);

	this->fText->setAlignment(Qt::AlignCenter | Qt::WordBreak);
	this->fText->setText(text);
	this->fUpperLayout->addWidget(this->fText);

	QSpacerItem* spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding,
					      QSizePolicy::Minimum);
	this->fButtonLayout->addItem(spacer);
}


void
QTadsDialog::addButton( const QString& text, bool isDefault )
{
	++this->fButtonCount;

	QPushButton* button = new QPushButton(text, this);
	button->setAutoDefault(true);
	button->setDefault(isDefault);
	this->fButtonLayout->addWidget(button);
	this->fButtonLayout->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding,
						     QSizePolicy::Minimum));

	this->fButtons.push_back(ButtonItem(button, this->fButtonCount));
	connect(button, SIGNAL(clicked()), this, SLOT(clickHandler()));
}


int
QTadsDialog::start()
{
	return (this->exec() == QDialog::Rejected) ? 0 : this->fResult;
}


void
QTadsDialog::clickHandler()
{
	for (ButtonVector::const_iterator i = fButtons.begin(); i != fButtons.end(); ++i) {
		if (i->button == sender()) {
			this->fResult = i->id;
			this->accept();
		}
	}
}

