/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* This file provides some helper-types needed by QTads.
 */

#include "config.h"

#include <qstring.h>

/* Stores information about how characters appear on screen.
 */
struct QTadsTextFormat {
	QTadsTextFormat()
	: high(false), italics(false)
	{}

	bool
	operator ==( const QTadsTextFormat& fmt )
	{
		return (this->high == fmt.high && this->italics == fmt.italics);
	}

	bool
	operator !=( const QTadsTextFormat& fmt )
	{
		return (not this->operator ==(fmt));
	}

	bool high;    // Are the characters highlighted?
	bool italics; // Are the characters italized?
};


/* Holds a string together with information about its appearance on the
 * screen.
 */
struct QTadsFormattedString {
	QTadsFormattedString( const QString& qStr, const QTadsTextFormat& fmt )
	: s(qStr), f(fmt)
	{}

	QString s;
	QTadsTextFormat f;
};
