/***************************************************************************
 *   Copyright (C) 2007 by Dominik Riebeling                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
/* Taken from the Rockbox installer, rbutilqt */

#include <QtGui>

#include "browsedirtree.h"

#ifdef WIN32
/* this is dirty hack to prevent A: drive displayed on Windows */
QFileInfoList QDir::drives()
{
    QFileInfoList list = QFSFileEngine::drives();
    if (list.at(0).absoluteFilePath() == "A:/")        list.removeAt(0);
    return list;
}
#endif

BrowseDirtree::BrowseDirtree(QWidget *parent, const QString &caption) : QDialog(parent)
{
    ui.setupUi(this);
    this->setModal(true);
    ui.tree->setModel(&model);
    model.setReadOnly(true);
    model.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase);

    if(caption!="")
        setWindowTitle(caption);

    // disable size / date / type columns
    ui.tree->setColumnHidden(1, true);
    ui.tree->setColumnHidden(2, true);
    ui.tree->setColumnHidden(3, true);
    ui.tree->setAlternatingRowColors(true);
}


void BrowseDirtree::setDir(const QDir &dir)
{
    qDebug() << "BrowseDirtree::setDir()" << model.index(dir.absolutePath());

    // do not try to hilight directory if it's not valid.
    if(!dir.exists()) return;
    // hilight the set directory if it's valid
    if(model.index(dir.absolutePath()).isValid()) {
        QModelIndex p = model.index(dir.absolutePath());
        ui.tree->setCurrentIndex(p);
        ui.tree->expand(p);
        ui.tree->scrollTo(p);
        ui.tree->resizeColumnToContents(0);
    }
}

void BrowseDirtree::setDir(const QString &dir)
{
    QDir d(dir);
    setDir(d);
}

void BrowseDirtree::setRoot(const QString &dir)
{
    ui.tree->setRootIndex(model.index(dir));
}

void BrowseDirtree::setFilter(const QDir::Filters &filters)
{
    model.setFilter(filters);
}


void BrowseDirtree::accept()
{
    QString path;
    path = model.filePath(ui.tree->currentIndex());

    this->close();
    emit itemChanged(QDir::toNativeSeparators(path));
    setResult(QDialog::Accepted);
}

QString BrowseDirtree::getSelected()
{
    QString path;
    path = model.filePath(ui.tree->currentIndex());
    return QDir::toNativeSeparators(path);
}


