# Copyright 2006 Joe Wreschnig
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# $Id: wav.py 3684 2006-07-23 22:20:43Z piman $

import os
import wave

import gst

from formats._audio import AudioFile

extensions = [".wav"]

if gst.registry_get_default().find_plugin("wavparse") is None:
    extensions = []

class WAVEFile(AudioFile):
    format = "WAVE"

    def __init__(self, filename):
        f = wave.open(filename, "rb")
        self["~#length"] = f.getnframes() // f.getframerate()
        self.sanitize(filename)

    def sanitize(self, filename):
        super(WAVEFile, self).sanitize(filename)
        self["title"] = os.path.basename(self["~filename"])[:-4]

    def write(self):
        pass

    def can_change(self, k=None):
        if k is None: return ["artist"]
        else: return k == "artist"

info = WAVEFile
