/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/sound.h>

#include "race_math.h"
#include "car.h"
#include "player.h"
#include "attractor.h"
#include "ai.h"
#include "game_data.h"
#include "game_config.h"

#include "car_sfx.h"


CL_SoundBuffer *CarSfx::engine_start;
std::vector<CL_SoundBuffer*> CarSfx::engine_high;
std::vector<CL_SoundBuffer*> CarSfx::engine_low;



void CarSfx::init()
{
#ifdef RACE_SOUND
	// nothing here
#endif
}




/* Calc distance to player and store the value. (Players store distance to AIs.)
 * Next frame check if player is closer than last frame. If true, increase the
 * AI cars sounds frequency, if distance is longer lower frequence to make a
 * 'car passing by' sound. (aka doppler effect, IIRC)
 * 
 * TODO: what shall we do with 2 player mode?
 * 	     Use Panning so that p1 uses left speaker and p2 right speaker?
 */

void CarSfx::update_ai_engine_frequency()
{
#ifdef RACE_SOUND
	std::vector<Car*>::iterator it;

	for( it = GameData::cars.begin();
		 it != GameData::cars.end();
		 it++)
	{
		if( (*it)->is_player() )
		{
			float p_x = (*it)->get_x();
			float p_y = (*it)->get_y();
		
			std::vector<Car*>::iterator AI_it;
			for( AI_it = GameData::cars.begin();
				 AI_it != GameData::cars.end();
				 AI_it++)
			{
				if( (*AI_it)->is_ai() )
				{
					float ai_x = (*AI_it)->get_x();
					float ai_y = (*AI_it)->get_y();
				
					(*AI_it)->old_dist = (*AI_it)->dist;
					(*AI_it)->dist = RaceMath::distance( p_x, p_y, ai_x, ai_y );
					
					if( (*AI_it)->dist < Config::engine_sound_radius )
						(*AI_it)->sound_controller.play_engine_sound = true;
					else
						(*AI_it)->sound_controller.play_engine_sound = false;
				}
			}
		}
	}

	for( it = GameData::cars.begin();
		 it != GameData::cars.end();
		 it++)
	{
		if( (*it)->is_ai() && (*it)->sound_controller.play_engine_sound )
		{
			// cout << "dist: " << (*it)->dist << endl;
			
			(*it)->sound_controller.set_volume( float( 0.5f - ((*it)->dist/Config::engine_sound_radius)/2 ));
			
			if( (*it)->dist > (*it)->old_dist )
				(*it)->sound_controller.increase_pitch( (*it)->dist, (*it)->old_dist );
			else
				(*it)->sound_controller.decrease_pitch( (*it)->dist, (*it)->old_dist );
		}
	}
#endif
}





