/*
 This Game is distributed under the GNU GENERAL PUBLIC LICENSE 
 version 2. See COPYING for details.                           
                                                               
 Copyright (C) 1999, 2000, 2001 Harry Storbacka                            
                                                               
 dust.cpp                                                    
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <iostream>
#include <algorithm>
#include <cmath>

#include "map.h"
#include "race.h"
#include "object_3d.h"
#include "texture.h"
#include "graphics.h"
#include "config.h"
#include "game_data.h"

#include "dust.h"


Dust::Dust(float _x, float _y, float _z, int _speed, int _angle, bool _water )
{
	x = _x;
	y = _y;
	z = _z;
	
	water = _water;
	
	speed =  _speed / 3;
	angle =  _angle + 1;
	
	life_time = CL_System::get_time();
	
	// sort by y values
	std::sort( GameData::dust_list.begin(), GameData::dust_list.end() );
}

Dust::~Dust()
{
   // cout << "dust deleted" << endl;
}

void Dust::show()
{
	
	if( water )
	{
		Gfx::TrackGfx->dust_water_texture->bind();
		glColor4f( 0.2f, 0.3f, 0.8f, 0.4f );
	}
	else
	{
		Gfx::TrackGfx->dust_road_texture->bind();
		glColor4f( 0.8f, 0.7f, 0.3f, 0.4f );
	}
   
	glPushMatrix();

	glTranslatef( x, y, z );
	
	float scale = 1.0f + (CL_System::get_time()-life_time) / 1024.0f;	
	glScalef( scale, scale, scale );

	Gfx::TrackGfx->dust->draw();

/*	glBegin( GL_QUADS );
		 glTexCoord2f(0.0f, 1.0f); glVertex3f( 0.0f, -0.5f, 0.0f ); // dl
		 glTexCoord2f(0.0f, 0.0f); glVertex3f( 0.0f, -0.5f, 0.5f ); // ul
		 glTexCoord2f(1.0f, 0.0f); glVertex3f( 0.0f,  0.5f, 0.5f ); // ur
		 glTexCoord2f(1.0f, 1.0f); glVertex3f( 0.0f,  0.5f, 0.0f ); // dr
		 
		 glTexCoord2f(0.0f, 1.0f); glVertex3f( -0.5f, 0.0f, 0.0f );
		 glTexCoord2f(0.0f, 0.0f); glVertex3f( -0.5f, 0.0f, 0.5f );
		 glTexCoord2f(1.0f, 0.0f); glVertex3f(  0.5f, 0.0f, 0.5f );
		 glTexCoord2f(1.0f, 1.0f); glVertex3f(  0.5f, 0.0f, 0.0f );
*/
	glEnd();

	glPopMatrix();
}

void Dust::update(float move_time )
{
   float dx = move_time * speed*(cos( angle*(M_PI/16)));
   float dy = move_time * speed*(sin( angle*(M_PI/16)));   

   x += dx;
   y += dy;
}

