/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi>
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "../tile_enums.h"
#include "../map.h"
#include "../graphics.h"

#include "../../editor/editor_gfx.h"
#include "../../editor/track.h"

#include "ramp.h"

std::vector<CL_Surface> Ramp::ramps;

void Ramp::draw( int x, int y, int item )
{
	if( item >= Items(RAMP_U ) && item <= Items(RAMP_R) )
		ramps[item - 60].put_screen( x, y );
}

void Ramp::add_ramp( int x, int y, int item )
{
	Track::track->set_data( x, y, item );
	do_ramp_speed_fix( x, y, item );
}


void Ramp::do_ramp_speed_fix( int x, int y, int item )
{
	int m_x = x; 
	int m_y = y;

	if( item >= 60 && item <= 63 )
	{
		if( item == RAMP_U || item == RAMP_D )
		{
			/*
			 *   R--
			 *   --- 
			 */ 
		
			{for( int i=0; i<2; i++ )
			{
				for( int j=0; j<3; j++ )
		  		{
			  		Track::track->set_data( m_x +j, m_y +i, item + 8 );
				}
			}}		
		}

		if( item == RAMP_R || item == RAMP_L )
		{
			/*   R-
			 *   --
			 *   --
			 */ 
		
			{for( int i=0; i<3; i++ )
			{
				for( int j=0; j<2; j++ )
		  		{
			  		Track::track->set_data( m_x +j, m_y +i, item + 8 );
				}
			}}		
		}

		// set top-left back to ramp_gfx.
		Track::track->set_data( m_x, m_y, item );	
	}
}


void Ramp::undo_ramp_speed_fix( int x, int y )
{
	int item = Track::track->get_data( x, y );
	
	int m_x = x;
	int m_y = y;
	
	if( item >= 60 && item <= 63 )
	{
		if( item == RAMP_U || item == RAMP_D )
		{
			/*
			 *   R-- 
			 *   --- 
			 */
		
			{for( int i=0; i<2; i++ )
			{
				for( int j=0; j<3; j++ )
		  		{
			  		Track::track->set_data( m_x +j, m_y +i, 0 );
				}
			}}
		}

		if( item == RAMP_R || item == RAMP_L )
		{
			/*   R-
			 *   --
			 *   --
			 */ 
		
			{for( int i=0; i<3; i++ )
			{
				for( int j=0; j<2; j++ )
		  		{
			  		Track::track->set_data( m_x +j, m_y +i, 0 );
				}
			}}
		}

		// set top-left back to ramp_gfx.
		Track::track->set_data( m_x, m_y, 0 );
	}
}




void Ramp::load( CL_ResourceManager &res )
{
	ramps.clear();

	for( int i = 0; i < 4; i++ )
	{
	  	CL_String path = "ramp/ramp_";
		path += i;
		ramps.push_back( CL_Surface( path, &res ) );
	}
}


