/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/


#include <ClanLib/core.h>

#include <fstream>

#include <ClanLib/sound.h>

#ifdef RACE_VORBIS
	#include <ClanLib/vorbis.h>
#endif

#include "game_config.h"
#include "music.h"
#include "debug.h"
#include "config.h"

short Music::next_track;
bool Music::stop_music;
char Music::last_track;

CL_ResourceManager Music::music_res;
CL_SoundBuffer_Session Music::playback;
CL_SoundBuffer *Music::buf = NULL;


void Music::init()
{
#ifdef RACE_SOUND 
#ifdef RACE_VORBIS
	
	RaceDebug::print( "music::init", 10 );
	
	try
	{
		RaceDebug::print("Resources: Music: resources/music.res", 7);
		
		CL_String path(DATADIR);
		path += "resources/music.res";
		music_res = CL_ResourceManager( path, false );
	}
	catch(CL_Error err)
	{
		cout << err.message.c_str() << endl;
		std::cout << "------> Music OFF" << std::endl;
		Config::music_on = false;
		return;
	}
	
	buf = NULL;
	next_track = 1;
#endif // RACE_VORBIS
#endif // RACE_SOUND
}



void Music::update()
{
#ifdef RACE_SOUND 
#ifdef RACE_VORBIS

//	RaceDebug::print( "music::update", 10 );

	if( !Config::music_on ) return;

//	RaceDebug::print( "music::update:  music is on", 10 );

	if( buf != NULL ) 
	{
		if( playback.is_playing() == false )
		{
			if( load_track(next_track) )
			{
				play_track();
				next_track++;
			}
			else
		  	{
				next_track++;
			}
	
			if( next_track > 5 )
		  		next_track = 0;
		}
	}
	else
	{
		// RaceDebug::print( "music: buf == NULL", 10 );
	}   

#endif 
#endif 
}



bool Music::load_track(int num)
{
#ifdef RACE_SOUND 
#ifdef RACE_VORBIS
	if( !Config::music_on ) return false;

	RaceDebug::print( "music::load_track", 10 );
	
	if( num > 13 && num < 20 ) num = 13;

	if( buf != NULL )
	{
		playback.stop();
		if( playback.set_position_relative(1.0f))
			CL_System::keep_alive();
		delete buf;
		buf = NULL;
	}

	// We don't want to listen to the same track again 

	if( num < 6 )
	{
		if( num == last_track  )
		{
  			num++;
			if( num > 5 ) num = 0;
		}
		last_track = num;
	}


	CL_String original_res_name = "track_";

	int tmp = 0;

	while( buf == NULL && tmp < 10 )
	{
		CL_String res_name = original_res_name + num;

		CL_Resource resource = music_res.get_resource( res_name );
		resource.load();
	
		CL_String filename = resource.get_full_location();

		// Check if file exists
		ifstream fin( filename.get_string() );
		if( fin.is_open() == false )
		{
		  	fin.close();
			num++;
			if( num > 5 )
		  		num = 0;
			tmp++;
			continue;
		}
		fin.close();
		
		try
		{
			RaceDebug::print( "Music::load_track: filename:", 10 );
			RaceDebug::print( filename.get_string(), 10 );
			
			// buf = CL_SoundBuffer::create( new CL_VorbisSoundProvider(filename.get_string()), true);
			buf = load_ogg( res_name, &music_res );
			
			if( buf == NULL )
			{
				cout << "error loading music" << endl;
				exit(1);
			}		   
			
			playback = buf->prepare();
			playback.set_volume( 0.6 );
		}
		catch( CL_Error err)
		{
			cout << err.message.c_str() << endl;
			Config::music_on = false;
			return false;
		}
	}
 #endif
 #endif
	return true;
}


void Music::play_track()
{
#ifdef RACE_SOUND 
#ifdef RACE_VORBIS
	if( !Config::music_on ) return;

	RaceDebug::print( "music::play_track", 10 );

	if( buf != NULL )
	{
		if( playback.is_playing() == false )
		{
			playback.play();
		}
	}
 #endif
 #endif
}

void Music::fade_out()
{
#ifdef RACE_SOUND 
#ifdef RACE_VORBIS
	if( !Config::music_on ) return;

	RaceDebug::print( "music::fade_out", 10 );

	if( buf == NULL )
	  	return;

	if( playback.is_playing() == false )
		return;

	playback.stop();
 #endif
 #endif
}

