#include "defs.h"
#include "explode.h"
#include "allegro.h"

int last_explode = 0;

ExplosionClass::ExplosionClass( int cx, int cy, double walkx, double walky, int rad ):
x( cx ),
y( cy ),
vx( cx ),
vy( cy ),
wx( walkx ),
wy( walky ),
radius( rad ),
max_rad( rad ){}

bool ExplosionClass::update() {
	vx += wx;
	vy += wy;
	x = (int)vx;
	y = (int)vy;

	radius--;
	if ( radius <= 0 ) return true;
	return false;
}


void ExplosionClass::Draw( BITMAP * who, int offset ) {

	int color = e_color[(int)((double)radius / (double)max_rad * (double)(MAX_E_COLOR-1))];
	circlefill( who, x, y+offset, radius, color );
}


void addExplode( ExplosionClass ** explode_array, int MAX_EXPL_ARRAY, ExplosionClass * who ) {
	if ( explode_array == NULL ) {
		delete who;
		return;
	}

	if ( explode_array[ last_explode ] != NULL )
		delete explode_array[ last_explode ];
	explode_array[ last_explode ] = who;
	last_explode = (last_explode+1) % MAX_EXPL_ARRAY;

}
