#include "allegro.h"
#include "defs.h"
#include "hull_weapon.h"
#include "hull_weapon_beam.h"
#include "ebox.h"

Beam_WHull::Beam_WHull( double str, int xf, int yf, int ang ):
HullWeapon( 0, 1, str*2 ),
x_size( xf ),
y_size( yf ),
angle( ang ) {

	drawLevel = 20;
	shade = new int[ 6 ];

	float h;

	h = str * 70.0;
	int r1, g1, b1;
	hsv_to_rgb( h, 1.0, 1.0, &r1, &g1, &b1 );
	int r2, g2, b2;
	hsv_to_rgb( h, 1.0, 0.4, &r2, &g2, &b2 );
	blend_palette( shade, 6, makecol(r2,g2,b2), makecol(r1,g1,b1) );

	collide = new ECollide();
	collide->setXS( xf/2 );
	collide->setYS( yf/2 );
	collide->my_size = xf/2;
	EBox * arch = new EBox( 0, 0, xf, yf );
	collide->add( arch );

	collide->finalize();

}


void Beam_WHull::Draw( BITMAP * who, int x, int y ) {
	int mx = x_size/2;
	int my = y_size/2;

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0 );

	for ( int q = 0; q < 5 && x-mx+q < x; q++ ) {
		line( who, x-mx+q, y-my, x-mx+q, y+my, shade[q] );
		line( who, x+mx-q, y-my, x+mx-q, y+my, shade[q] );
	}
	if ( x-mx+5 < x )
		rectfill( who, x-mx+5, y-my, x+mx-5, y+my, shade[5] );
	else    line( who, x, y-my, x, y+my, shade[5] );

	if ( strength >= 3 ) {

		int color = 1;
		int dir = 1;
		for ( int q = -y_size/2; q < y_size/2; q++ ) {

			int sang = (angle+q*4+360*9)%360;
			if ( abs(q) % 10 == 0 ) {
				color += dir;
				if ( color == 5 ) dir = -1;
				if ( color == 1 ) dir = 1;
			}
			if ( sang >= 90 && sang <= 270 )
				if ( x_size/2 > 3 )
					circlefill( who, (int)(x-tsine[sang]*x_size/2), y-q, 1, shade[color] );

		}

	}

	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0 );

}


Beam_WHull::~Beam_WHull() {
	delete collide;
	delete[] shade;
}
