/******************************************************************************
*		       							      *
* config.h (part of rCalc)					       	      *
* Copyright 2000 Gary Benson <rat@spunge.org>			       	      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

typedef unsigned char boolean;
#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/*****************************************************************************/

/* The calculator's internal state.
*/
#define MAX_VARIABLE_NAME_LEN	31	/* Maximum length of a variable name */
#define MAX_VARIABLES		1024	/* Maximum number of variables	     */

typedef enum
{
	angleDegrees, angleRadians
}
ANGLE;

typedef struct
{
	char name[MAX_VARIABLE_NAME_LEN+1];
	double value;
}
VARIABLE;

/* Warning: HELPTOPIC order must match the array at the top of main.c */
typedef enum
{
	helpNoHelp,

	/* Main help screen */
	helpIntro,

	/* Preferences box */
	helpPrefBehaviour, helpPrefAppearance, helpPrefCalculator,

	/* Commands */
	helpExit, helpHelp, helpLs,   helpRm,    helpMode,

	/* Functions */
	helpInt,  helpAbs,  helpLogs, helpSqrt,  helpTrig,  helpHype,

	/* Constants */
	helpConstants,

	NUM_HELPTOPICS
}
HELPTOPIC;

typedef struct
{
	ANGLE		angleMode;
	boolean		angleMode_mod;
	
	VARIABLE	variables[MAX_VARIABLES];
	int		nVariables;
	boolean		variables_mod;

	/* This one is a command - if helpTopic is other than helpNoHelp,
	** the help browser will be launched on an rCalc_config_NotifyChange()
	*/
	HELPTOPIC	helpTopic;
}
CALCSTATE;

/*****************************************************************************/

/* The user interface state.
*/

typedef enum
{
	scrollbarLeft, scrollbarRight, scrollbarHidden,
}
SCROLLBARPOS;

typedef enum
{
	colBackground=0, colForeground=7, colPrompt=4, colError=1, colDebug=2,
}
COLOURS;

typedef struct
{
	SCROLLBARPOS	scrollbarPos;
	boolean		termBell;
	boolean		cursBlink;
	int		scrollbackLines;
	boolean		scrollOnKey;
	boolean		scrollOnOut;
	char	       *fontName;
	unsigned short	palette[3][18];
}
UISTATE;

/*****************************************************************************/

extern	CALCSTATE	*cfgCalc;
extern	UISTATE		*cfgUI;

extern	void	rCalc_config_init( void );
extern	void	rCalc_config_load( void );
extern	void	rCalc_config_save( void );
extern	void	rCalc_config_free( void );

extern	void	rCalc_config_Lock( void );
extern	void	rCalc_config_Unlock( void );
extern	void	rCalc_config_NotifyChange( void );

/*** end of config.h *********************************************************/
