/******************************************************************************
*		       							      *
* engine.h (part of rCalc)					       	      *
* Copyright 2000 Gary Benson <rat@spunge.org>			       	      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* Observer functions for the commands, functions, constants and variables:
** used for tab complete, help and 'ls' commands.
*/
extern	int	 rCalc_engine_GetNumCommands( void );
extern	char	*rCalc_engine_GetCommandName( int i );
extern HELPTOPIC rCalc_engine_GetCommandHelp( int i );

extern	int	 rCalc_engine_GetNumFunctions( void );
extern	char	*rCalc_engine_GetFunctionName( int i );
extern HELPTOPIC rCalc_engine_GetFunctionHelp( int i );

extern	int	 rCalc_engine_GetNumConstants( void );
extern	char	*rCalc_engine_GetConstantName( int i );
extern	double 	 rCalc_engine_GetConstantValue( int i );
extern HELPTOPIC rCalc_engine_GetConstantHelp( int i );

#define rCalc_engine_GetNumVariables() 	 (cfgCalc->nVariables)
#define rCalc_engine_GetVariableName(i)  (cfgCalc->variables[(i)].name)
#define rCalc_engine_GetVariableValue(i) (cfgCalc->variables[(i)].value)

/* Deal with a line of user input: determine whether it is
** a command or an expression, and handle it accordingly.
*/
extern	int	 rCalc_engine_Execute( char *command );

/* Evaluate an expression, without command handling or locking.
*/
extern	void	 rCalc_engine_Evaluate( char *expression );

/* Initialise the calculation engine
*/
extern	void	 rCalc_engine_Initialise( void );

/*** end of engine.h *********************************************************/
