#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

void RCUI_create_lists()
{
  int i=0;
  GtkTreeIter iter;
  gchar *value;
  
  ui_stores.mainw_store = gtk_list_store_new (N_COLUMNS, 
    G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING);
  
  ui_stores.varw_myv_store = gtk_list_store_new (RCUI_VARW_NCOLUMNS, 
    G_TYPE_STRING, G_TYPE_STRING);
  
  ui_stores.varw_myf_store = gtk_list_store_new (RCUI_VARW_NCOLUMNS, 
    G_TYPE_STRING, G_TYPE_STRING);

  ui_stores.varw_biv_store = gtk_list_store_new (RCUI_VARW_NCOLUMNS, 
    G_TYPE_STRING, G_TYPE_STRING);

  ui_stores.varw_bif_store = gtk_list_store_new (RCUI_VARW_NCOLUMNS, 
    G_TYPE_STRING, G_TYPE_STRING);
    
  ui_stores.history = gtk_list_store_new (1, G_TYPE_STRING);
      
  for( i=0; i < NUM_DEFAULT_FUNCTIONS; i++ )
  {
    gtk_list_store_append (ui_stores.varw_bif_store, &iter);  
    gtk_list_store_set (ui_stores.varw_bif_store, &iter,
                    RCUI_VARW_NAME_COLUMN, rCalc_engine_GetFunctionName(i-1),
                    RCUI_VARW_SECOND_COLUMN, rCalc_engine_GetFunctionExpr(i-1),
                    -1); 
  }
  
  for( i=0; i < rCalc_engine_GetNumConstants(); i++ )
  {
     value = g_strdup_printf("%.18f", rCalc_engine_GetConstantValue(i));
     gtk_list_store_append (ui_stores.varw_biv_store, &iter);  
     gtk_list_store_set (ui_stores.varw_biv_store, &iter,
                    RCUI_VARW_NAME_COLUMN, rCalc_engine_GetConstantName(i),
                    RCUI_VARW_SECOND_COLUMN, value,
                    -1);
     g_free(value);
  }  
}

void RCUI_empty_list (GtkListStore *list_store)
{
  gboolean valid;
  GtkTreeIter iter;
  
  /* remove existing lines */
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter);
  while (valid)
  {
    valid = gtk_list_store_remove (list_store, &iter);
  }
}

void RCUI_print_list (GtkListStore *list_store)
{
  gboolean valid;
  int i=0;
  GtkTreeIter iter;
  gchar *name=NULL, *in_expr=NULL;
  
  g_print("-- List begin --\n");
  
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter);
  
  while (valid)
  {
      gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, NAME_COLUMN, &name, INPUT_COLUMN, &in_expr, -1);      
      g_print("Line %d: %s / %s\n",i,name, in_expr);
      valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
      i++;
      if (in_expr) g_free (in_expr);
      if (name) g_free (name);
  }
  g_print("-- List end --\n");
}

void RCUI_update_varw_lists()
{
  int i=0;
  gchar *value;
  GtkTreeIter iter;
  
  RCUI_empty_list(ui_stores.varw_myv_store);
  RCUI_empty_list(ui_stores.varw_myf_store);
  
  for( i=0; i < rCalc_engine_GetNumVariables(); i++ )
	{
    if (!g_ascii_strncasecmp(RC_engine->variables[i].name,"Ans",3)==0) {
      value = g_strdup_printf("%.12f", rCalc_engine_GetVariableValue(i));
      
      
      gtk_list_store_append (ui_stores.varw_myv_store, &iter);  
      gtk_list_store_set (ui_stores.varw_myv_store, &iter,
                    RCUI_VARW_NAME_COLUMN, rCalc_engine_GetVariableName(i),
                    RCUI_VARW_SECOND_COLUMN, value,
                    -1);
      g_free(value);
    }
    		
	}
  
  for( i=NUM_DEFAULT_FUNCTIONS; i < rCalc_engine_GetNumFunctions()+1; i++ )
  {
    gtk_list_store_append (ui_stores.varw_myf_store, &iter);  
    gtk_list_store_set (ui_stores.varw_myf_store, &iter,
                    RCUI_VARW_NAME_COLUMN, rCalc_engine_GetFunctionName(i-1),
                    RCUI_VARW_SECOND_COLUMN, rCalc_engine_GetFunctionExpr(i-1),
                    -1);
  }  
}

void RCUI_add_to_history (GtkListStore *history_list, gchar *text)
{
  GtkTreeIter iter;
  gtk_list_store_prepend (history_list, &iter);
  
  gtk_list_store_set (history_list, &iter, 0, text, -1);
}
