/*
 * Copyright (C) 1999, 2000  Upi Tamminen <desaster@imnetti.fi>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <pthread.h>

#include "reppu.h"

#define RECV(a, b) a[recv(b, a, MAXDATASIZE, 0)] = '\0';

struct {
    char string[256];
} *filelist;

pthread_mutex_t frame_mutex=PTHREAD_MUTEX_INITIALIZER,
		flist_mutex=PTHREAD_MUTEX_INITIALIZER;;

void mkpath (char *path);
int waitforok(int sockfd);

int client(char *host, char *blend)
{
    int sockfd;
    long size, total_size;
    char msg[MAXDATASIZE], buf[MAXDATASIZE];
    struct sockaddr_in dest_addr;
    struct hostent *he;
    extern int current_frame, end_frame;
    FILE *blend_file;
    
    if ((he = gethostbyname(host)) == NULL) {
	char errbuf[512];

	sprintf(errbuf, ":: Connection failed [%s]", host);
	herror(errbuf);
	pthread_exit(NULL);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    dest_addr.sin_family = AF_INET;
    dest_addr.sin_port = htons(REPPU_PORT);
    dest_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(dest_addr.sin_zero), 8);
    
    if (connect(sockfd, (struct sockaddr *)&dest_addr,
		sizeof(struct sockaddr)) == -1) {
	char errbuf[512];
	sprintf(errbuf, ":: Connection failed [%s]", host);
	perror(errbuf);
	pthread_exit(NULL);
    }

    printf(":: Connected: %s (sending %s)\n", host, blend);

    sprintf(msg, "BLEND");
    send(sockfd, msg, strlen(msg), 0);
    if (waitforok(sockfd) != 0) exit(1);

    if ((blend_file = fopen(blend, "r")) == NULL) {
	fprintf(stderr, "error opening %s\n", blend);
	exit(1);
    }
    fseek(blend_file, 0, SEEK_END);
    total_size = ftell(blend_file);

    sprintf(msg, "%ld", total_size);
    send(sockfd, msg, strlen(msg), 0);
    if (waitforok(sockfd) != 0) exit(1);

    fseek(blend_file, 0, SEEK_SET);
    
    while (!feof(blend_file)) {

	size = ftell(blend_file) + MAXDATASIZE > total_size ? MAXDATASIZE -
		((long) ftell(blend_file) + MAXDATASIZE - total_size):
		MAXDATASIZE;
	
	fread(&msg, MAXDATASIZE, 1, blend_file);
	send(sockfd, msg, size, 0);
    }

    if (waitforok(sockfd) != 0) exit(1);
    fclose(blend_file);
    
    printf(":: Ready: %s\n", host);

    /* rendering loop */
    while (current_frame < end_frame + 1) {

	int frame;
	long total_size, pos = 0;
	FILE *created_file;
	
	sprintf(msg, "RENDER");
	send(sockfd, msg, strlen(msg), 0);
	if (waitforok(sockfd) != 0) exit(1);
	
	pthread_mutex_lock(&frame_mutex);
	frame = current_frame;
	current_frame ++;
	
	printf(">> %d/%d [%s]\n", frame, end_frame, host);
	sprintf(msg, "%d", frame);
	
	pthread_mutex_unlock(&frame_mutex);
	
	send(sockfd, msg, strlen(msg), 0);
	RECV(buf, sockfd);
	
	send(sockfd, "OK", 2, 0);
	
	if (strcmp(buf, "ERROR") == 0) {
	    printf(":: Rendering failed: %s\n", host);
	    pthread_exit(NULL);
	}

	pthread_mutex_lock(&flist_mutex);
	strncpy(filelist[frame].string, buf, 255);
	filelist[frame].string[255] = '\0';
	pthread_mutex_unlock(&flist_mutex);

	mkpath(buf);

	RECV(buf, sockfd);

	total_size = atol(buf);
	send(sockfd, "OK", 2, 0);

	if ((created_file = fopen(filelist[frame].string, "w")) == NULL) {
	    fprintf(stderr, "error opening %s\n", filelist[frame].string);
	    pthread_exit(NULL);
	}

	while (pos < total_size) {

	    int size;
	    size = recv(sockfd, &buf, MAXDATASIZE, 0);
	    pos += size;
	    fwrite(buf, size, 1, created_file);
	}

	fclose(created_file);
    }

    sprintf(msg, "DONE");
    send(sockfd, msg, strlen(msg), 0);
    if (waitforok(sockfd) != 0) exit(1);

    close(sockfd);

    printf(":: Finished: %s\n", host);
    return 0;
}

int waitforok(int sockfd)
{
    char buf[MAXDATASIZE];
    RECV(buf, sockfd);
    if (strcmp(buf, "OK") != 0) {
	fprintf(stderr, "Got [%s] instead of [OK]\n", buf);
	return 1;
    }
    return 0;
}

void mkpath (char *path)
{
    int done = 0;
    char *file, p[512], dir[512];
    
    file = (char *) rindex(path, '/');
    if (file != NULL) {
	file ++;
	bzero(dir, strlen(dir));
	strncpy(dir, path, strlen(path) - strlen(file));
	dir[strlen(path) - strlen(file)] = '\0';
    } else return;
    
    strcpy(p, dir);
    while (!done) {
	
	unsigned char tmp1[1024], tmp2[1024];
	
	tmp1[0] = '\0';
	strcpy(tmp2, p + 1);
	
	if (index(tmp2, '/') != NULL) {
	    strcpy(p, (char *) index(tmp2, '/'));
	    strncpy(tmp1, dir, strlen(dir) - strlen(p));
	    tmp1[strlen(dir) - strlen(p)] = '\0';
	    mkdir(tmp1, 0755);
	}
	else done = 1;
    }
    return;
}
