# $Header: /CVSROOT/yahoo/audit/rt/stats/db/db.pm,v 1.1 1998/08/20 04:49:18 serge Exp $
# interface to DBI module

package db;

use DBI;
use strict;
require 'db/dbconfig.pm';

my $dbh;

# read config and connect to the database
sub db_connect
{
my $res;

   $dbh = DBI->connect("DBI:mysql:$db::dbase:$db::dbhost",$db::dbuser,$db::dbpwd);
   return "Unable to connect to database: " . $DBI::errstr . "\n" if ! defined $dbh;
   return '';
}

sub db_close
{
   $dbh->disconnect;
}

# fetch data to %array[i]
# size of array == number of rows returned
sub db_fetch
{
my ($query,$row_hash) = @_;
my $sth = $dbh->prepare($query); 
my $i = 0;
my $a;

   $sth->execute || return "Unable to execute query: " . $dbh->errstr . "\n";
   while( $a = $sth->fetchrow_hashref )
   {
	@$row_hash[$i++] = $a;
   }
   $sth->finish;
   return '';
}

sub db_quote
{
my $var = shift;

   return $dbh->quote($var);
}

# execute non-select queries, return number of updated rows
sub db_update
{
my $query = shift;
my $rc;

   $rc = $dbh->do($query);
   return (0,"Unable to execute query: " . $dbh->errstr . "\n") if ! defined $rc || $rc < 0;
   return ($rc,'');
}
1;
