#! /usr/bin/env perl

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database;

binmode( STDOUT, "utf8" );

my @tests = (
    'CHARACTER(2)',
    'CHAR(10)',
    'CHARACTER VARYING(100)',
    'VARCHAR(1)',
    'CHARACTER LARGE OBJECT(2K)',
    'CLOB(10M)',
    'NATIONAL CHARACTER(50)',
    'NCHAR(100)',
    'NATIONAL CHARACTER VARYING(1)',
    'NVARCHAR(100)',
    'NATIONAL CHARACTER LARGE OBJECT(50M)',
    'NCLOB(1T)',
    'TEXT',
    'TINYTEXT',
    'MEDIUMTEXT',
    'LONGTEXT',
);

for my $test (@tests) {
    printf "%-40s %u\n", $test, Database::is_character_string( $test );
}
