/*
 *  Rexx/Tk
 *  Copyright (C) 1999  Roger O'Connor <ocon@metronet.com>
 *  Copyright (C) 2000  Mark Hessling  <M.Hessling@qut.edu.au>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "rxpack.h"

#include <tk.h> 
/*
 * The following is to get around the Win32 ports of Tcl/Tk that have
 * version numbers in their libraries. This is intended to make Rexx/Tk
 * independent of this crap.
 */
#ifdef WIN32
# define Tcl_CreateInterp  RexxTk_TclCreateInterp
# define Tcl_Eval          RexxTk_TclEval
# define Tcl_Init          RexxTk_TclInit
# define Tk_Init           RexxTk_TkInit
# define Tcl_FindExecutable RexxTk_TclFindExecutable
extern Tcl_Interp *RexxTk_TclCreateInterp(void);
extern int         RexxTk_TclEval(Tcl_Interp *, char *);
extern int         RexxTk_TclInit(Tcl_Interp *);
extern int         RexxTk_TkInit(Tcl_Interp *);
extern void        RexxTk_TclFindExecutable(char *);
typedef Tcl_Interp *TclCreateInterpType(void);
typedef int TclEvalType(Tcl_Interp *, char *);
typedef int TclInitType(Tcl_Interp *);
typedef int TkInitType(Tcl_Interp *);
typedef void TclFindExecutableType(char *);
#endif
/*
 * Rexx/Tk error stuff and commonly shared memory for extension
 * libraries
 */
typedef struct
{
   Tcl_Interp *RexxTkInterp;
   int  REXXTK_IntCode;
   char REXXTK_ErrMsg[256];
#ifdef WIN32
   TclCreateInterpType *Dyn_TclCreateInterp;
   TclEvalType *Dyn_TclEval;
   TclInitType *Dyn_TclInit;
   TkInitType *Dyn_TkInit;
   TclFindExecutableType *Dyn_TclFindExecutable;
#endif
} REXXTKDATA;

#define TCLCOMMANDLEN 1024

void SetIntError(REXXTKDATA *,int, char *);
void ClearIntError(REXXTKDATA *);
int ReturnError( REXXTKDATA *,RXSTRING *, int,  char *);
int rtk_procOptArgs(RFH_ARG0_TYPE name,char czCommand[], RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG1_TYPE start);
int rtk_procOptArgArray(RFH_ARG0_TYPE name,char czCommand[], RFH_ARG2_TYPE argv, RFH_ARG1_TYPE start);
int rtk_procOptArgIndirect(RFH_ARG0_TYPE name,char czCommand[], RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG1_TYPE start);
int rtk_procOptArgDash(RFH_ARG0_TYPE name,char czCommand[], RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG1_TYPE start);
char *rtk_quote(char string[]) ;
/*
 * Type A commands
 * Tk form:
 *   command pathName ?options?
 * Rexx form:
 *   TkCommand(pathName, [options...])
 */
RFH_RETURN_TYPE rtk_TypeA(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE );
/*
 * Type B commands
 * Tk form:
 *   command arg ?arg arg ...?
 * Rexx form:
 *   TkCommand(arg, [arg, arg, ...])
 */
RFH_RETURN_TYPE rtk_TypeB(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE);
/*
 * Type C commands
 * Tk form:
 *   pathName command ?arg arg ...?
 * Rexx form:
 *   TkCommand(pathName, [arg, arg, ...])
 */
RFH_RETURN_TYPE rtk_TypeC(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE);
/*
 * Type D commands
 * Tk form:
 *   pathName command arg ?options?
 * Rexx form:
 *   TkCommand(pathName, arg, [options...])
 */
RFH_RETURN_TYPE rtk_TypeD(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE );
/*
 * Type E commands
 * Tk form:
 *   pathName command ?options?
 * Rexx form:
 *   TkCommand(pathName, [options...])
 */
RFH_RETURN_TYPE rtk_TypeE(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE);
/*
 * Type F commands
 * Tk form:
 *   command pathName... ?options?
 * Rexx form:
 *   TkCommand(pathName [,pathName...] [options...])
 */
RFH_RETURN_TYPE rtk_TypeF(REXXTKDATA *,char [],RFH_ARG0_TYPE,char *,RFH_ARG1_TYPE, RFH_ARG2_TYPE, RFH_ARG4_TYPE);

