#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "torus.icc"
int main (int argc, char**argv) {
  environment rheolef (argc, argv);
  Float tol    = (argc > 1) ? atof(argv[1]) : 1e-7;
  bool do_dump = (argc > 2) ? true : false;
  field uh, phi_h;
  din >> catchmark("u")   >> uh
      >> catchmark("phi") >> phi_h;
  const space& Xh = phi_h.get_space();
  band gh (phi_h);
  space Bh (gh.band(), "P1");
  form m (Bh, Bh, "mass",      gh);
  form a (Bh, Bh, "grad_grad", gh);
  size_t d = Bh.get_geo().dimension();
  field pi_h_u = interpolate(Bh, u(d));
  field eh = pi_h_u - uh;
  field phi_h_band = phi_h [gh.band()];
  Float c1 = m(eh,phi_h_band)/m(phi_h_band,phi_h_band);
  field one (Bh, 1);
  Float meas_gamma = m(one,one);
  Float c2 = m(one,eh)/meas_gamma;
  eh = eh - c1*phi_h_band - c2*one;
  Float err_l2 = sqrt(m(eh,eh));
  Float err_h1 = sqrt(a(eh,eh));
  derr << "err_l2 = " << err_l2 << endl
       << "err_h1 = " << err_h1 << endl;
  if (do_dump) {
    dout << catchmark ("u")  << uh
         << catchmark ("ue") << pi_h_u
         << catchmark ("eh") << eh;
  }
  return (err_l2 < tol && err_h1 < tol) ? 0 : 1;
}
