#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "poiseuille.h"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  string sys_coord = omega.coordinate_system_name();
  Float c = omega.xmax()[1];
  space X1h (omega, "P1", "vector");
  space Bh  (omega, "bubble", "vector");
  X1h.block ("wall");
  X1h.block ("upstream");
  X1h[1].block ("axis");
  X1h[1].block ("downstream");
  space Xh = X1h * Bh;
  space Qh  (omega, "P1");
  space Wh  (omega["upstream"], "P1");
  field uh (Xh, 0);
  field ph (Qh, 0);
  uh[0][0]["upstream"] = interpolate (Wh, u(c,sys_coord));
  form a1 (X1h, X1h, "2D_D");
  form ab (Bh,  Bh,  "2D_D");
  form b1 = - form(X1h, Qh, "div");
  form bb = - form(Bh,  Qh, "div");
  form a = {{a1,  0},
            { 0, ab}};
  form b =  {b1, bb};
  form mp (Qh, Qh, "mass");
  solver_abtb stokes (a.uu(), b.uu(), mp.uu());
  stokes.solve (-(a.ub()*uh.b()), -(b.ub()*uh.b()),
                uh.set_u(),       ph.set_u());
  dout << catchmark("inv_lambda") << 0 << endl
       << catchmark("u")  << uh[0]
       << catchmark("ub") << uh[1]
       << catchmark("p")  << ph;
}
