#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char** argv) {
  environment rheolef (argc,argv);
  Float inv_lambda;
  field uh;
  din >> catchmark("inv_lambda") >> inv_lambda
      >> catchmark("u")          >> uh;
  const geo& omega = uh.get_geo();
  const space& Xh  = uh.get_space();
  string grad_approx = "P" + itos(Xh.degree()-1) + "d";
  space Th  (omega, grad_approx, "tensor");
  space T0h (omega, grad_approx);
  form two_D  (Xh, Th,  "2D");
  form div    (Xh, T0h, "div");
  form inv_mt (Th,  Th,  "inv_mass");
  form inv_m  (T0h, T0h, "inv_mass");
  field trace_h = inv_m*(div*uh);
  field sigma_h = inv_mt*(two_D*uh);
  if (inv_lambda != 0)
    for (size_t i_comp = 0; i_comp < uh.size(); i_comp++)
      sigma_h(i_comp,i_comp) += (1/inv_lambda)*trace_h;
  dout << catchmark("s") << sigma_h;
}
