#ifndef H_ASSEMBLE
#define H_ASSEMBLE

#include "rlinetd.h"

struct array {
#ifdef MEMDEBUG
	char *id;
#endif	
	rl_opcode_t *elems;
	int len;
};

struct optab {
	rl_opcode_t opcode;
	int nargs;
	struct array *after;
};

struct opmeta {
#ifdef MEMDEBUG
	char *id;
#endif	
	int len;
	rl_opcode_t *bytes;
	struct array *after;
	struct array *ops;
	rl_opcode_t **fixup;
};

struct opmetalist {
#ifdef MEMDEBUG
	char *id;
#endif	
	int len;
	struct opmeta **opms;
};

struct opmeta *opmeta_make(int, rl_opcode_t, ...);
int opmetalist_add(struct opmetalist *, struct opmeta *);
struct opmetalist *opmetalist_join(struct opmetalist *, struct opmetalist *);
void opmeta_fixup(struct opmeta *, int, rl_opcode_t *);
struct opmetalist *opmetalist_new();
struct oplist *opmetalist_resolve(struct opmetalist *);
void opmetalist_free(struct opmetalist *);

#endif /* !H_ASSEMBLE */
