/*  completion.c: maintaining the completion list, my_completion_function()
    (callback for readline lib) */

/*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License , or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

    You may contact the author by:
       e-mail:  hlub@knoware.nl
*/



#include "rlwrap.h"

/* forward declarations */

static void insert_word (const char *word);
static void change_working_directory(void);
char *my_history_completion_function (char *prefix, int state);
/* static void print_list(void); */

typedef struct cl_node { 
  char * word;           
  struct cl_node  *next;
} Cl_node;

static Cl_node *cl_head;

static void
insert_word (const char* word)
{
  Cl_node **p, *new_node;
  int res;
  char *word_copy=0;
  /* printf ("Inserting %s\n", word); */  
  for (p = &cl_head; *p ; p = &((*p) -> next)) {
    res = strcmp(word, (*p) -> word);
    if (res > 0)
      continue;
    if (res == 0)
      return;
    if (res < 0)
      break;
  }
    

  new_node = (Cl_node *) mymalloc (sizeof (Cl_node));
  word_copy = mystrndup(word, strlen(word));
  new_node -> word = word_copy;
  new_node -> next = *p;
  *p = new_node;
}  


void
print_list()
{
  Cl_node *p;
  for (p = cl_head; p; p = p -> next) {
    printf("\"%s\"\n", p -> word);
  }
}


void
init_completer(const char *completions_file)
{
  FILE *compl_fp;
  char buffer[BUFFSIZE];

  if((compl_fp =  fopen(completions_file, "r")) == NULL)
     myerror("Could not open %s", completions_file);

  while (fgets(buffer, BUFFSIZE, compl_fp) != NULL)
    feed_into_completion_list(buffer);

  /* print_list(); */
}

void
feed_into_completion_list(const char *line)
{
  char *word,buf[BUFFSIZE], *bufp;
  mystrlcpy(buf, line, sizeof(buf));
  for (bufp=buf ; (word = strtok(bufp, rl_basic_word_break_characters)); bufp = NULL) /* Aargh! strtok() */
      insert_word(word);      
}

char *
my_completion_function(char *prefix, int state)
{
  char *p, *q = NULL, *completion;
  int failed=FALSE;
  static Cl_node *candidate; /* remember this between invocations */

  if (*prefix == '!')
      return my_history_completion_function(prefix + 1, state); 
  
  if (state == 0) {      /* follow the list until the first string > prefix is found */
    for (candidate = cl_head; candidate; candidate = candidate -> next) {
      if (strcmp(candidate -> word, prefix) > 0)
	break;
    }
  }
  if (candidate == NULL) 
    failed=TRUE;
  else
    for (p=candidate -> word, q = prefix; *p && *q; p++, q++) {
      if (*p != *q)
      failed = TRUE;
    }	
  /* either text starts prefix, or vice versa */
  if ((!failed) && *q) /* text starts prefix, i.e. prefix too long, i.e. no completions found */
    failed = TRUE;

  if (failed) {
    if (complete_filenames) {
      change_working_directory();
      return  rl_filename_completion_function (prefix, state);
    } else {	
      return NULL; 
    }
  }
  /* we cannot just return candidate->word because readline will free it */
  completion = mysavestring(candidate -> word);
  candidate = candidate -> next;
  return completion; 
}


char *my_history_completion_function (char *prefix, int state)
{
  while (next_history())
    ;
  if (state || history_search_prefix(prefix,-1) < 0)
    return NULL;
  return mysavestring (current_history() -> line);
}

  

static void
change_working_directory () {
#ifdef HAVE_PROC_PID_CWD
  static char * slaves_working_directory = NULL;

  if (!slaves_working_directory) { /* initialise slaves_working_directory */
    int len;
    size_t const buf_size = sizeof("/proc/") + sizeof(pid_t) * 3 + sizeof("/cwd");
    slaves_working_directory = (char *) mymalloc(buf_size);
    len = snprintf1(slaves_working_directory, buf_size, "/proc/%d/cwd", child_pid); 
  }
  
  chdir(slaves_working_directory); /* may fail silently */
  /* myerror("Couldn't change to slaves working directory"); */
#endif     
}






