//autoqueue.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

int autoqueue(pli_t queue) {
 struct rpld_playlist         * pl = rpld_pl_get_by_id(queue);
 struct rpld_playlist_entry   * plent;
 struct rpld_playlist_entry   * copy;
 struct rpld_playlist_search    pls;
 struct rpld_playlist_pointer * plp, * plp_copy;

 ROAR_DBG("autoqueue(void) = ?");

 if ( pl == NULL ) {
  ROAR_DBG("autoqueue(void) = -1");
  return -1;
 }

 if ( rpld_pointer_is_set(POINTER_CURRENT, queue, -1) == 0 ) {
  ROAR_DBG("autoqueue(void): no current pointer");

  plp = rpld_pointer_get(POINTER_DEFAULT, queue, -1);
  if ( plp == NULL ) {
   ROAR_DBG("autoqueue(void): no default pointer");
   return -1;
  }

  ROAR_DBG("autoqueue(void): we have a default pointer at %p", plp);

  if ( rpld_plp_copy(&plp_copy, plp) == -1 ) {
   ROAR_DBG("autoqueue(void): copy of default pointer to current pointer failed");
   return -1;
  }

  rpld_pointer_set(POINTER_CURRENT, queue, -1, plp_copy);

  rpld_plp_unref(plp);
  rpld_plp_unref(plp_copy);

  if ( rpld_pointer_is_set(POINTER_CURRENT, queue, -1) == 0 ) {
   ROAR_DBG("autoqueue(void): still no current pointer");
   return -1;
  }
 }

 plp = rpld_pointer_get(POINTER_CURRENT, queue, -1);

 ROAR_DBG("autoqueue(void): we have a current pointer at %p", plp);

 if ( (plent = rpld_plp_search(plp)) == NULL ) {
  rpld_plp_unref(plp);
  return -1;
 }

 if ( (copy = rpld_ple_copy(plent)) == NULL ) {
  rpld_plp_unref(plp);
  return -1;
 }

 rpld_pl_push(pl, copy);

 if ( !( plp->pls.type == RPLD_PL_ST_RANDOM          ||
         plp->pls.type == RPLD_PL_ST_RANDOM_LIKENESS ) ) {
         
  if ( rpld_pointer_set(POINTER_CURRENT, queue, -1, NULL) == 0 ) {

   if ( plent->list.next != NULL ) {
    plent = plent->list.next;

    memset(&pls, 0, sizeof(pls));

#ifdef HAVE_LIB_UUID
    pls.type = RPLD_PL_ST_UUID;

    uuid_copy(pls.subject.uuid, plent->uuid);
#else
    pls.type = RPLD_PL_ST_TRACKNUM_LONG;

    pls.subject.long_tracknum = plent->global_tracknum;
#endif

    plp_copy = rpld_plp_init(NULL, &pls);
    rpld_pointer_set(POINTER_CURRENT, queue, -1, plp_copy);
    rpld_plp_unref(plp_copy);
   }
  }
 }

 rpld_plp_unref(plp);
 return 0;
}

//ll
