#ifndef ROBODOC_ROBODOC_H
#define ROBODOC_ROBODOC_H

/*
 *    ROBODoc - a documentation extraction program for several languages.
 *
 *    Copyright (C) 1994-2003  Frans Slothouber and Jacco van Weert.
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef VERSION
#define VERSION "4.0.18"
#endif

#define COMMENT_ROBODOC \
    "Generated with ROBODoc Version " VERSION " (" __DATE__ ")\n"
#define COMMENT_COPYRIGHT\
    "ROBODoc (c) 1994-2004 by Frans Slothouber and Jacco van Weert.\n"

#define DO_SORT             (1<<0)
#define DO_FOLDS            (1<<1)
#define DO_NODESC           (1<<2)
#define DO_TOC              (1<<3)
#define DO_MAKE_DOCUMENT    (1<<4)
#define DO_INCLUDE_INTERNAL (1<<5)
#define DO_INTERNAL_ONLY    (1<<6)
#define DO_TELL             (1<<7)
#define DO_INDEX            (1<<8)
#define DO_SINGLEDOC        (1<<9)
#define DO_MULTIDOC         (1<<10)
#define DO_SINGLEFILE       (1<<11)
#define DO_NOSOURCE         (1<<12)
#define DO_ROBO_HEAD        (1<<13)     /* DCD Added */
#define DO_NO_TABLE         (1<<14)     /* DCD Added - causes dbsgml to produce indexed master index rather than tabled one */
#define DO_SECTIONS         (1<<15)
#define DO_CMODE            (1<<16)
#define DO_LOCKHEADER       (1<<17)
/* Output Modes */


/****t* Generator/T_RB_DocType
 * FUNCTION
 *   Enumerated for the various output formats that are
 *   supported by ROBODoc.
 * NOTES
 *   These should be prefixed with RB_ 
 * SOURCE
 */

typedef enum
{
    ASCII = 0,
    HTML,
    DBSGML, /* Does not work at the moment */
    LATEX,
    RTF,
    TROFF, /* Does not work at the moment */
    XMLDOCBOOK,
    /* SIZE_MODES, */
    /* Reserved for Future Use */
    /* ANSI, */
    /* GNUINFO, */
    /* XML, */
    UNKNOWN
} T_RB_DocType;

/*****/


/* Evil macros !! */
#define skip_while(cond) { for (;*cur_char && (cond);cur_char++) ; }
#define find_eol   { for (;*cur_char && *cur_char!='\n';cur_char++) ; }
#define find_quote { for (;*cur_char && *cur_char!='\"';cur_char++) ; }

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE  1
#endif

/* Prototypes */

void                RB_Set_Doc_Base( char *path );

#endif /* ROBODOC_ROBODOC_H */
