/*
 * rtmath.stdlib.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// rtmath.stdlib.cpp: Random implementation using CStdLib

#ifndef __LRT_MATH_STDLIB__
#define __LRT_MATH_STDLIB__

#include <stdlib.h>
#include <math.h>
#include <sys/timeb.h>

#include "rtmath.h"

namespace lrt {

int Math::rand(int from, int to)
{
	if(!randomInit) randomize();

	return (int)((float)(to - from + 1) * ::rand() / (RAND_MAX+1.0f)) + from;
}

void Math::seed(unsigned long seed)
{
	srand(seed);
	randomInit = true;
}

void Math::randomize()
{
	struct timeb tp;
	ftime( &tp );
	srand( tp.time );

	randomInit = true;
}


double Math::sqrt(double num)
{
	return ::sqrt(num);
}

double Math::log10(double num)
{
	return ::log10(num);
}

double Math::ln(double num)
{
	return ::log(num);
}

double Math::exp(double num)
{
	return ::exp(num);
}

double Math::sin(double num)
{
	return ::sin(num);
}

double Math::cos(double num)
{
	return ::cos(num);
}

double Math::tan(double num)
{
	return ::tan(num);
}

} // namespace


#endif

