/*
 * robdefines.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares DefineInputStream. 
  */


#ifndef __RT_DEFINESTREAM__
#define __RT_DEFINESTREAM__

#include "robvars.h"

#include <rtstring.h>
#include <rtcollect.h>
#include <rtstreams.h>
#include <rtmap.h>

using namespace lrt;

namespace rt {

/// An input stream which automatically replaces Defines while reading
class DefineInputStream : public InputStream  {
public:
	static const String whitespace;
	DefineInputStream(InputStream *in, const String &separators, const char commentStart = 0);
	virtual void close();
	virtual ~DefineInputStream();

	void setIgnoreComments(bool);
	void setAutoTrim(bool);
	void setEnableDefines(bool);
	
	virtual void mark();
	virtual void reset();
	virtual bool markSupported();
	virtual bool fail();

	virtual int read();
	RobLoadReturnType getWord(String& word, const String& specialSeps = "");
	String getLine(bool skipEmpty = true);

	int getLineNumber();
	bool skipRestOfLine();

	bool eos();

	/** checks the identifier (eg label name, define param) for validity.
      * The function assumes that the first magic char (eg '?') was removed from the identifier. */
	bool isIdentifierValid(const String& str);

private:
	class Define {
	public:
		Define(const String& name = "");
		~Define() {}

		InputStream* getStream();

		String name, value;
		Vector<String> params;
		int lineOffset;
	};

	class StreamInfo {
	public:
		StreamInfo();
		StreamInfo(Define& define);
		~StreamInfo();

		int lineNum;
		int lineOffset;
		int buf;
		bool eol;
		StringMap<String> params;
	};

	class StringInStream : public InputStream {
	public:
		StringInStream(const String&);
		virtual ~StringInStream() {}
		virtual int read();
		bool eos();
	private:
		const String& str;
		int pos;
	};

	void unread(int c);
	RobLoadReturnType readParams(StringMap<String>& params, Vector<String>& paramNames);
	RobLoadReturnType createDefine();
	
	Vector<StreamInfo> infos;
	Vector<InputStream*> streams;
	StringMap<Define> defineMap;

	enum {
		identCharInvalid = 0x00,
		identCharValidFirst = 0x01,
		identCharValidNext = 0x02,
		identCharValidAlways = 0x03
	};

	int validAsIdentifierChar[256];
	void initValidIdentifierChars();

	int markLineNum;
	String separators;
	char commentStart;
	bool ignoreComments, autoTrim, defines;
	int curStream;
};

} // namespace

#endif 
