/*
 * robwxutil.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// utility functions for wxWidgets 

#ifndef __FF_CONTROL_WX__
#define __FF_CONTROL_WX__

namespace lrt { 
	class String;
	template<class T> class Array;
}
class wxString; 
class wxWindow;
class wxListCtrl;

// The class is only intended for grouping the functions.
// Note also that its name starts with a capital 'W' to distinguish it from 
// the 'real' wxWindows classes
class Wx {
public:
	// Calls the operating-system-specific wxEntry() function
	// without passing command line arguments
	// @return The program's intended exit code
	static int Startup(); 

	static wxString Conv(const lrt::String&);
	static lrt::String Conv(const wxString&);

	// wxConfig settings storage stuff
	static void StoreString(const wxString& str, const wxString& cfgKey); 
	static wxString ReadString(const wxString& def, const wxString& cfgKey); 

	static void StoreArray(const lrt::Array<int>& arr, const wxString& cfgKey);
	static lrt::Array<int> ReadArray(int def, const wxString& cfgKey);

	static void StoreRect(wxWindow* win, const wxString& cfgKey);
	static void RestoreRect(wxWindow* win, const wxString& cfgKey);
	static void StoreColumns(wxListCtrl* ctrl, const wxString& cfgKey);
	static void RestoreColumns(wxListCtrl* ctrl, const wxString& cfgKey);

	// html display
	static void ShowInBrowser(const wxString& htmlFile); 
};


#endif // file
