#* 
#* ------------------------------------------------------------------
#* Role PlayingDB V2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* Main.tcl - Main Role Playing DB Script
#* Created by Robert Heller on Tue Aug 11 11:59:05 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: Main.tcl,v $
#* Revision 1.7  1999/07/13 01:30:12  heller
#* Fix documentation: spelling, punctuation, etc.
#*
#* Revision 1.6  1999/04/20 13:15:09  heller
#* Final changes
#*
#* Revision 1.5  1999/04/18 00:34:07  heller
#* Fix -transient flag for Tcl/Tk 8.0.
#*
#* Revision 1.4  1999/03/28 06:20:44  heller
#* Update on-line help.
#*
#* Revision 1.3  1998/12/30 15:05:20  heller
#* Added in documentation
#*
#* Revision 1.2  1998/12/27 20:49:36  heller
#* Fix spelling errors
#*
#* Revision 1.1  1998/12/27 16:44:23  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Role Playing DB -- A database package that creates and maintains
#* 		       a database of RPG characters, monsters, treasures,
#* 		       spells, and playing environments.
#* 
#*     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:Main.tcl -- Main window and common GUI procedures
#@Label:Main.tcl
#$Id: Main.tcl,v 1.7 1999/07/13 01:30:12 heller Rel1 $

global tcl_rcFileName
# This is the name of the file containing general Tcl/Tk preferences.
# [index] tcl_rcFileName!global variable

catch "source $tcl_rcFileName"

# Withdraw the main toplevel
wm withdraw .

global LibDir
# This is the path to the script library directory.  It is computed from
# the directory name of the script.
# [index] LibDir!global variable

set LibDir "[file dirname [info script]]"

global CopyBuffer
# Buffer for selection copying.
# [index] CopyBuffer!global variable

set CopyBuffer {}

image create photo DeepwoodsBanner -file [file join $LibDir DeepwoodsBanner.gif]
# Deepwoods banner image.  Used in the splash screen.
# [index] DeepwoodsBanner!image

global GenSym
# Global variable used to hold symbol sequence counter used for generating
# unique symbols used for toplevel window names.
# [index] GenSym!global variable

set GenSym 1

# Declare the packages we will need:
# The C++ code...
package require Rpg

# The Standard Menu Bar code
package require StdMenuBar

# The character editor
package require RPGEdCharacter

# The monster editor
package require RPGEdMonster

# The spell editor
package require RPGEdSpell

# The treasure editor
package require RPGEdTreasure

# The trick/trap editor
package require RPGEdTrickTrap

# The dressing editor
package require RPGEdDressing

# The map editor
package require RPGEdMap

# The space editor
package require RPGEdSpace

# The help system
package require RPGHelp

proc SplashScreen {} {
  # Build the ``Splash Screen'' -- A popup window that tells the user what 
  # we are all about.  It gives the version and brief copyright information.
  #
  # The upper part of the splash screen gives the brief information, with
  # directions on how to get detailed information.  The lower part contains
  # an image banner for Deepwoods Software.
  # [index] SplashScreen!procedure

  #global help_tips
  # build widget .rpgSplash
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .rpgSplash"
  } {
    catch "destroy .rpgSplash"
  }
  toplevel .rpgSplash 

  # Window manager configurations
  wm positionfrom .rpgSplash program
  wm sizefrom .rpgSplash program
  wm resizable .rpgSplash 0 0
  wm geometry .rpgSplash "+[expr ([winfo screenwidth .] / 2) - 254]+[expr ([winfo screenheight .] / 2) - 92]"
  wm title .rpgSplash {Role Playing DB 2.0}
  wm transient .rpgSplash .

  bind .rpgSplash <1> {
      if {"[info procs XFEdit]" != ""} {
        catch "XFDestroy .rpgSplash"
      } {
        catch "destroy .rpgSplash"
      }
    }
  #enable_balloon .rpgSplash
  #set help_tips(.rpgSplash) {Click anywhere to dismiss splash window.}

  # build widget .rpgSplash.frame1
  frame .rpgSplash.frame1 \
    -background {#2ba2bf}

  # build widget .rpgSplash.frame1.label4
  label .rpgSplash.frame1.label4 \
    -background {#2ba2bf} \
    -text {[rpg]}
#    -image SmallFace

  # build widget .rpgSplash.frame1.message5
  message .rpgSplash.frame1.message5 \
    -background {#2ba2bf} \
    -foreground {white} \
    -aspect {1500} \
    -font {-adobe-times-medium-r-*-*-*-100-*-*-*-*-*-*} \
    -padx {5} \
    -pady {2} \
    -text {Role Playing DB Version 2.0, Copyright (C) 1996-1998 Robert Heller D/B/A Deepwoods Software
Role Playing comes with ABSOLUTELY NO WARRANTY; for details select 'Warranty...' under
the Help menu.  This is free software, and you are welcome to redistribute it under certain
conditions; select 'Copying...' under the Help menu.  You can get technical support for a
$50 shareware fee; for details select 'Registering...' under the Help menu.}

  # build widget .rpgSplash.frame2
  frame .rpgSplash.frame2 \
    -background {#2ba2bf}

  # build widget .rpgSplash.frame2.label3
  label .rpgSplash.frame2.label3 \
    -background {#2ba2bf} \
    -image {DeepwoodsBanner}

  # pack master .rpgSplash.frame1
  pack configure .rpgSplash.frame1.label4 \
    -expand 1 \
    -side left
  pack configure .rpgSplash.frame1.message5 \
    -fill x \
    -side right

  # pack master .rpgSplash.frame2
  pack configure .rpgSplash.frame2.label3

  # pack master .rpgSplash
  pack configure .rpgSplash.frame1 \
    -expand 1 \
    -fill both
  pack configure .rpgSplash.frame2 \
    -fill x
# end of widget tree


}

SplashScreen

update

after 60000 {catch [list destroy .rpgSplash]}

proc GenerateToplevelName {base} {
# Procedure to generate a unique toplevel window name.
# <in> base -- this is the base name to be used for the name.  A sequence 
# number is appended to this name to form a unique name.
# [index] GenerateToplevelName!procedure

  global GenSym

  while {[winfo exists .$base$GenSym]} {incr GenSym}

  return $base$GenSym
}

proc GetTopLevelOfFocus {menu} {
# Procedure to get the toplevel that presently has focus.  This is used when
# generic pulldown menus are activated to determine which object the menu
# refers to.
# <in> menu -- this is the menu that was selected.  This is used to select
# which display to search on.
# [index] GetTopLevelOfFocus!procedure

  if {[catch [list winfo toplevel [focus -displayof $menu]] tl]} {
    return {}
  } elseif {[string length "$tl"] > 0} {
    return $tl
  } else {
    return {}
  }
}

proc RPGMenuBar {{toplevel .}} {
# Procedure to generate a menu bar for RPG toplevels.
# This procedure is used to create uniform menubars for all first-class 
# toplevels used in the RPG DB package.
# <in> toplevel -- the toplevel to attach the menu to.
# [index] RPGMenuBar!procedure

  if {"$toplevel" == {.}} {
    set Mname .menuBar
  } else {
    set Mname $toplevel.menuBar
  }

  MakeStandardMenuBar $Mname $toplevel

  global tcl_platform
  if {$tcl_platform(platform) == "macintosh"} {
    set apMenu [GetMenuByName Apple $Mname]
    $apMenu add command -label {About Role Playing DB}
  }

  set fm [GetMenuByName File $Mname]
  $fm entryconfigure {Open...} -command "OpenWindow  \[GetTopLevelOfFocus $Mname\]"
  $fm entryconfigure {Save} -command "SaveWindow  \[GetTopLevelOfFocus $Mname\]"
  $fm entryconfigure {Save As...} -command "SaveAsWindow  \[GetTopLevelOfFocus $Mname\]"
  $fm entryconfigure {Print...} -command "PrintWindow  \[GetTopLevelOfFocus $Mname\]"
  $fm entryconfigure {Exit} -command {ExitRPG}
  $fm entryconfigure {Close} -command "CloseWindow \[GetTopLevelOfFocus $Mname\]"
  $fm delete {New}
  $fm insert 0 cascade -label {New} -underline {0} -menu $fm.new
  MakePullDown $fm.new \
	{command -label {Character} -command {RPGEdCharacter}} \
	{command -label {Monster} -command {RPGEdMonster}} \
	{command -label {Spell} -command {RPGEdSpell}} \
	{command -label {Map} -command {RPGEdMap}} \
	{command -label {Treasure} -command {RPGEdTreasure}} \
	{command -label {Trick / Trap} -command {RPGEdTrickTrap}} \
	{command -label {Dressing} -command {RPGEdDressing}}
   
}

global Toplevels
# This is a list of all current RPG DB toplevels.  As toplevels are created
# their names are added to this list, and as they are destroyed, they are
# removed from this list.
# [index] Toplevels!global variable

set Toplevels {}

proc RPGDestroyToplevel {tname} {
# This procedure destroys a selected RPG DB toplevel. The data object 
# associated with the toplevel is checked to see if it is ``dirty'' (modified)
# and if so, the user is given a chance to save the data object to disk.
# The memory used by the data object is also freed.
# <in> tname -- the name of the toplevel.
# [index] RPGDestroyToplevel!procedure

  global Toplevels
  set index [lsearch -exact $Toplevels $tname]
  if {$index < 0} {return}
  bind $tname <Destroy> {}
  catch [list destroy $tname]
  set Toplevels "[lreplace $Toplevels $index $index]"
  upvar #0 $tname data
  if ($data(dirty)) {
    CheckWriteDirtyRecord$data(class) $tname
  } elseif {[info exists data(object)] && [string length "$data(object)"] > 0} {
    catch "rename $data(object) {}"
  } elseif {[info exists data(cleanupFun)] && [string length "$data(cleanupFun)"] > 0} {
    catch [list $data(cleanupFun) $tname]
  }
  catch "unset data"
}

proc NoOperation args {
# Dummy procedure to be used as a place holder where a procedure is needed, but
# there is no operation to perform.
# <in> args -- random unused arguments.
# [index] NoOperation!procedure

}

proc RPGDestroyToplevelEvent {tl} {
# This procedure is bound to the Destroy event of RPG DB toplevels.  If ever
# the toplevel is destroyed via an event, this procedure catches the event
# and does the needed cleanup.  See RPGDestroyToplevel.
# <in> tl -- the name of the toplevel.
# [index] RPGDestroyToplevelEvent!procedure

  global Toplevels
  set index [lsearch -exact $Toplevels $tl]
  if {$index < 0} {return}
  set Toplevels "[lreplace $Toplevels $index $index]"
  upvar #0 $tl data
  if ($data(dirty)) {
    CheckWriteDirtyRecord$data(class) $tl
  } elseif {[info exists data(object)] && [string length "$data(object)"] > 0} {
    catch [list rename "$data(object)" {}]
  } elseif {[info exists data(cleanupFun)] && [string length "$data(cleanupFun)"] > 0} {
    catch [list $data(cleanupFun) $tl]
  }
  catch "unset data"
}

proc RPGToplevel {tname title class} {
# Procedure to create a proper RPG DB toplevel.  This procedure creates a
# toplevel window to edit an object of the specified class.
# <in> tname -- The name to use for the toplevel window.
# <in> title -- The string to place in the title of the toplevel window.
# <in> class -- The class of object the toplevel will edit.
# [index] RPGToplevel!procedure

  global tk_version

  # build widget $tname

  RPGDestroyToplevel $tname
  toplevel $tname -class $class
  upvar #0 $tname data
  catch "unset data"
  set data(class) $class
  set data(dirty) 0
  set data(filename) {}
  set data(filetype) {}

  # Window manager configurations
  wm positionfrom $tname ""
  wm sizefrom $tname ""
  wm maxsize $tname 1009 738
  wm minsize $tname 1 1
  wm protocol $tname WM_DELETE_WINDOW "RPGDestroyToplevel $tname"
  wm title $tname "$title"
  bind $tname <Destroy> {RPGDestroyToplevelEvent %W}

  if {$tk_version < 8.0} {
    RPGMenuBar $tname
  } else {
    $tname configure -menu .menuBar
  }

  global Toplevels
  lappend Toplevels $tname

}

proc SetDirty {tl} {
# Procedure to set the dirty flag for a toplevel's data object.
# <in> tl -- The name of the toplevel.
# [index] SetDirty!procedure

  upvar #0 $tl data
  set data(dirty) 1
}

proc CloseWindow {toplevel} {
# Procedure to close a toplevel (bound to the ``Close'' button under the 
# ``File'' menu).  This procedure closes a named toplevel window.  Proper
# cleanup operations are performed.
# <in> toplevel -- The name of the toplevel.
# [index] CloseWindow!procedure

  if {[string length "$toplevel"] == 0} {
    return
  }  
  RPGDestroyToplevel $toplevel
}

proc ExitRPG {} {
# Exit procedure for the RPG DB system.  This procedure cleans up all 
# outstanding toplevels and also confirms the exit with a dialog box.
# [index] ExitRPG!procedure

  global Toplevels
  if {[tk_dialog .askExit "Really Exit?" \
		"Do you really want to exit?" questhead 1 "Yes" "No"] != 0} {return}
  foreach tl $Toplevels {
    CloseWindow $tl
  }
  exit
}

proc OpenWindow {tl} {
# Procedure bound to the ``Open...'' menu item under the ``File'' menu.
# This procedure opens up a new window with old data (loaded from disk).
# If the current toplevel is of a particular class, a data object of the
# same class is opened.  Otherwise a menu listing a selection of object
# classes is presented to the user to choose from.
# <in> tl -- The toplevel with the focus.
# [index] OpenWindow!procedure

  if {"$tl" == {.}} {
    OpenWhat
    return
  } elseif {[string length "$tl"] == 0} {
    return
  }
  upvar #0 $tl data
  Open$data(class) $tl
}

proc OpenWhat {} {
# This procedure presents the user with a selection of object classes to
# open.
# [index] OpenWhat!procedure

  if {[winfo exists .openWhatMenu] == 0} {
    global tk_version
    if {$tk_version >= 8.0} {
      menu .openWhatMenu -tearoff 0
    } else {
      menu .openWhatMenu -tearoff 0 -transient 1
    }
    .openWhatMenu add command -label {Character} -command {OpenCharacter .}
    .openWhatMenu add command -label {Monster}   -command {OpenMonster .}
    .openWhatMenu add command -label {Spell}     -command {OpenSpell .}
    .openWhatMenu add command -label {Treasure}  -command {OpenTreasure .}
    .openWhatMenu add command -label {TrickTrap} -command {OpenTrickTrap .}
    .openWhatMenu add command -label {Dressing}  -command {OpenDressing .}
    .openWhatMenu add command -label {Map}       -command {OpenMap .}
  }
  .openWhatMenu post [winfo pointerx .] [winfo pointery .]
}

proc SaveWindow {tl} {
# Procedure bound to the ``Save'' menu item on the ``File'' menu.
# Saves the selected object in its current file name.  If no file is 
# associated with the object, the user is prompted for a new file name.
# <in> tl - The toplevel which has the focus.
# [index] SaveWindow!procedure

  if {"$tl" == {.}} {
    return
  } elseif {[string length "$tl"] == 0} {
    return
  }
  upvar #0 $tl data
  Save$data(class) $tl
}

proc SaveAsWindow {tl} {
# Procedure bound to the ``SaveAs...'' menu item on the ``File'' menu.
# Saves the selected object in a new file name.
# <in> tl - The toplevel which has the focus.
# [index] SaveAsWindow!procedure

  if {"$tl" == {.}} {
    return
  } elseif {[string length "$tl"] == 0} {
    return
  }
  upvar #0 $tl data
  SaveAs$data(class) $tl
}

proc PrintWindow {tl} {
# Procedure bound to the ``Print...'' menu item on the ``File'' menu.
# Prints the selected object.
# <in> tl - The toplevel which has the focus.
# [index] PrintWindow!procedure

  if {"$tl" == {.}} {
    return
  } elseif {[string length "$tl"] == 0} {
    return
  }
  upvar #0 $tl data
  Print$data(class) $tl
}
  
    

proc MainWindow {} {
# Procedure to create the main window.  This window consists of a collection
# of buttons to open various other toplevel windows to edit various data
# objects.
# [index] MainWindow!procedure

  RPGMenuBar .


  # build widget .mainFrame
  frame .mainFrame \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .mainFrame.left
  frame .mainFrame.left

  # build widget .mainFrame.left.character
  button .mainFrame.left.character \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Character} \
    -command {RPGEdCharacter}

  # build widget .mainFrame.left.monster
  button .mainFrame.left.monster \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Monster} \
    -command {RPGEdMonster}

  # build widget .mainFrame.left.spell
  button .mainFrame.left.spell \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Spell} \
    -command {RPGEdSpell}

  # build widget .mainFrame.left.map
  button .mainFrame.left.map \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Map} \
    -command {RPGEdMap}

  # build widget .mainFrame.right
  frame .mainFrame.right

  # build widget .mainFrame.right.treasure
  button .mainFrame.right.treasure \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Treasure} \
    -command {RPGEdTreasure}

  # build widget .mainFrame.right.trickTrap
  button .mainFrame.right.trickTrap \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Trick or Trap} \
    -command {RPGEdTrickTrap}

  # build widget .mainFrame.right.dressing
  button .mainFrame.right.dressing \
    -padx {9} \
    -pady {3} \
    -text {Make or Edit Dressing} \
    -command {RPGEdDressing}

  # build widget .mainFrame.right.exit
  button .mainFrame.right.exit \
    -padx {9} \
    -pady {3} \
    -text {Exit} \
    -command {ExitRPG}

  # pack master .mainFrame.left
  pack configure .mainFrame.left.character \
    -fill x \
    -padx 15 \
    -pady 15
  pack configure .mainFrame.left.monster \
    -fill x \
    -padx 15 \
    -pady 15
  pack configure .mainFrame.left.spell \
    -fill x \
    -padx 15 \
    -pady 15
  pack configure .mainFrame.left.map \
    -fill x \
    -padx 15 \
    -pady 15

  # pack master .mainFrame.right
  pack configure .mainFrame.right.treasure \
    -fill x \
    -padx 15 \
    -pady 15
  pack configure .mainFrame.right.trickTrap \
    -fill x \
    -padx 15 \
    -pady 15
  pack configure .mainFrame.right.dressing \
    -fill x \
    -padx 16 \
    -pady 15
  pack configure .mainFrame.right.exit \
    -fill x \
    -padx 15 \
    -pady 15

  # pack master .mainFrame
  pack configure .mainFrame.left \
    -expand 1 \
    -fill y \
    -side left
  pack configure .mainFrame.right \
    -expand 1 \
    -fill y \
    -side right

  # pack slave .mainFrame
  pack configure .mainFrame \
    -expand 1 \
    -fill both
# end of widget tree

  wm deiconify .
}

catch "bind IntEntry <KeyPress> {CheckInt %W}"

proc CheckInt {E} {
# Procedure to check for legal integer entries.  This procedure is bound to
# the KeyPress event.
# <in> E -- the entry widget to check.
# [index] CheckInt!procedure

  global BlankIntEntries
  set variable "[$E cget -textvariable]"
  if {[string length "$variable"] == 0} {
    set val "[$E get]"
    if {[catch [list expr int($val)] iv]} {
      bell
      $E delete 0 end
      $E insert 0 {0}
    } elseif {$val != $iv} {
      bell
      $E delete 0 end
      $E insert 0 "$iv"
    }
    return
  }
  upvar #0 $variable val
  if {[catch [list expr int($val)] iv]} {
    bell
    set val 0
  } elseif {$val != $iv} {
    bell
    set val $iv
  }
}

catch "bind FloatEntry <KeyPress> {CheckFloat %W}"

proc CheckFloat {E} {
# Procedure to check for legal floating point entries.  This procedure is 
# bound to the KeyPress event.
# <in> E -- the entry widget to check.
# [index] CheckFloat!procedure

  set variable "[$E cget -textvariable]"
  if {[string length "$variable"] == 0} {
    set val "[$E get]"
    if {[catch [list expr double($val)] iv]} {
      bell
      $E delete 0 end
      $E insert 0 {0}
    }
    return
  }
  upvar #0 $variable val
  if {[catch [list expr double($val)] iv]} {
    if {[string length "$val"] == 0} {return}
    bell
    set val 0
  }
}

catch "bind UpdComments <KeyPress> {UpdateComments %W comments}"

catch "bind UpdDescription <KeyPress> {UpdateComments %W description}"

proc UpdateComments {text field} {
# Procedure to update text fields.  This procedure is bound to
# the KeyPress event.
# <in> text -- the Text widget to check.
# <in> field -- the data field associated with this text widget.
# [index] UpdateComments!procedure

  set tl [winfo toplevel $text]
  upvar #0 $tl data
  set value "[$text get 1.0 end]"
  if {[string compare "$data($field)" "$value"] != 0} {
    set data($field) "$value"
    set data(dirty) 1
  }
}



MainWindow
