/* -*- C++ -*- */
/*************************************************************************
 * Copyright(c) 1995~2005  Masaharu Goto (cint@pcroot.cern.ch)
 *
 * For the licensing terms see the file COPYING
 *
 ************************************************************************/
// Complex.h

#ifndef COMPLEX_H
#define COMPLEX_H

#ifdef __hpux
#include <iostream.h>
#else
#include <iostream>
using namespace std;
#endif

// fNX //////////////////////////////////////////////////
class Complex {
 public:
  // 
  Complex(double a=0.0,double b=0.0) { re=a; im=b; }

  // 擾
  double real() const { return(re); }
  double imag() const { return(im); }

  // o֐ɂ鉉Zqd`
  Complex& operator+=(Complex& a);
  Complex& operator-=(Complex& a);
  Complex& operator*=(Complex& a);
  Complex& operator/=(Complex& a);

  // th֐ɂ鉉Zqd`
  friend bool operator==(Complex& a,Complex& b);
  friend bool operator!=(Complex& a,Complex& b){return(!(a==b));}
  friend Complex operator +(Complex& a,Complex& b);
  friend Complex operator -(Complex& a,Complex& b);
  friend Complex operator *(Complex& a,Complex& b);
  friend Complex operator /(Complex& a,Complex& b);
  friend ostream& operator <<(ostream& ios,Complex& a);

  // Zp֐̑d`
  friend double abs(Complex& a);
  friend Complex exp(Complex& a);

 private:
  double re,im;
};

#endif
