
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RNODE_FOREACH_H__
#define __RNODE_FOREACH_H__

#define RNODE_FOREACH(start_node,curnode)                               \
    do {                                                                \
        RNode **rnode_foreach_tmp_node;                                 \
        RArray *rnode_foreach_parent_stack;                             \
                                                                        \
        rnode_foreach_parent_stack = rarray_new (sizeof (RNode *), 64); \
        curnode = rlist_first (start_node->children);                   \
        while (curnode) {


#define RNODE_FOREACH_CLOSE \
            \
            /* Depth first, decend if we can */                         \
            if (!rlist_empty (curnode->children)) {                     \
                /* Save this node on the stack */                       \
                rnode_foreach_tmp_node = rarray_push (rnode_foreach_parent_stack);  \
                *rnode_foreach_tmp_node = curnode;                      \
                                                                        \
                curnode = rlist_first (curnode->children);              \
            } else {                                                    \
                curnode = rlist_next (curnode);                         \
            }                                                           \
                                                                        \
            if (!curnode) {                                             \
                rnode_foreach_tmp_node = rarray_pop (rnode_foreach_parent_stack);   \
                if (!rnode_foreach_tmp_node) {                          \
                    goto rnode_foreach_cleanup;                         \
                }                                                       \
                curnode = *rnode_foreach_tmp_node;                      \
                curnode = rlist_next (curnode);                         \
            }                                                           \
        }                                                               \
                                                                        \
rnode_foreach_cleanup:                                                  \
        rarray_free (rnode_foreach_parent_stack);                       \
                                                                        \
    } while (0)

#define RNODE_FOREACH_BREAK goto rnode_foreach_cleanup

#endif /* __RNODE_FOREACH_H__ */


