
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

/*
 * FIXME: 
 * 1. Therml parsing needs to be interuptable
 *    by the hanlders.
 * 2. Error messages needs to be passed around and freed
 *    as needed.
 * 3. On error we need to cleanup the mess the parser
 *    and we made.
 *
 * Notes:  This code ripped off the enode_therml.c code
 * written my Ian Main(I think).
 * 
 * Author(s): Matt Wimer
 */

#include <roy.h>


/* Structure to keep track of the state in the therml
 * parser */
typedef struct _RNodeThermlState	RNodeThermlState;

struct _RNodeThermlState {
    RArray *rnode_stack;
    RBuf *err;
    /* ... */
};


static void
rnode_therml_error_handler__P (ThermlParser *parser, int severity,
                               int linenum, int colnum,
                               const char *description);

static void
rnode_therml_pcommand_handler__P (ThermlParser *parser, RBuf *data);

static void
rnode_therml_node_start_handler__P (ThermlParser *parser, RBuf *type,
                                    RBHash *attribs);

static void
rnode_therml_node_end_handler__P (ThermlParser *parser, RBuf *type, RBuf *data);


static void
rnode_therml_error_handler__P (ThermlParser *parser, int severity,
                               int linenum, int colnum,
                               const char *description)
{
    printf ("Error parsing therml line %d, column %d: %s\n", linenum,
            colnum, description);
}


static void
rnode_therml_pcommand_handler__P (ThermlParser *parser, RBuf *data)
{
    printf ("pcomamnd for data: '%s'\n", rbuf_str (data));
}


static void
rnode_therml_node_start_handler__P (ThermlParser *parser, RBuf *type,
                                    RBHash *attribs)
{
    RBuf *err = NULL;
    RNode *new_node;
    RNode **tmpnode;
    RNode *current_node;
    ThermlAttribute *attrib;
    RNodeThermlState *state = therml_get_user_data (parser);

    tmpnode = rarray_last (state->rnode_stack);
    current_node = *tmpnode;
    
    printf ("new tag %s\n", rbuf_str (type));
    new_node = rnode_new_child_append (current_node, type, &err);   
    
    RBHASH_FOREACH (attribs, attrib) {
        printf ("  '%s'='%s'\n", rbuf_str (rbhash_entry_getkey (attrib)),
                rbuf_str (attrib->value));
        
        rnode_attrib_set (new_node, rbhash_entry_getkey (attrib), attrib->value, &err);

    } RFOREACH_CLOSE;

    tmpnode = rarray_append (state->rnode_stack);
    *tmpnode = new_node;
}

static void
rnode_therml_node_end_handler__P (ThermlParser *parser, RBuf *type, RBuf *data)
{
    RNode *current_node;
    RNode **tmpnode;
    RNodeThermlState *state = therml_get_user_data (parser);

    tmpnode = rarray_pop (state->rnode_stack);
    current_node = *tmpnode;

    printf ("tag end %s\n", rbuf_str (type));
}


RNode *
rnode_therml_parse (RBuf *therml, RBuf **err)
{
    RNode *node;
    RBuf * tmperr = NULL;

    node = rnode_new_child_append (NULL, rbuf_auto ("rnode-fake"), NULL);

    rnode_therml_append (node, therml, &tmperr);
    if (NULL != tmperr) {
        if (NULL != err)
            *err = tmperr;
        else
            rbuf_free (tmperr);

        rnode_destory (node, NULL);
        return NULL;			/* Error. */
    }

    return node;
}

void
rnode_therml_append (RNode *node, RBuf *therml, RBuf **err)
{
    ThermlParser *parser;
    RArray *rnode_stack;
    RNode **tmpnode;
    RNodeThermlState *state;

    /* Setup new therml parser and handlers */
    parser = therml_parser_new ();
    therml_set_error_handler (parser, rnode_therml_error_handler__P);
    therml_set_pcommand_handler (parser, rnode_therml_pcommand_handler__P);
    therml_set_node_start_handler (parser, rnode_therml_node_start_handler__P);
    therml_set_node_end_handler (parser, rnode_therml_node_end_handler__P);

    /* Setup an enode stack that will keep track of which enode
     * we are working with */
    rnode_stack = rarray_new (sizeof (RNode), 32);
    tmpnode = rarray_append (rnode_stack);
    *tmpnode = node;

    /* Setup the state struct that will keep track of the current
     * handle, and the enode stack */
    state = rchunk_alloc (sizeof (RNodeThermlState));
    state->rnode_stack = rnode_stack;
    therml_set_user_data (parser, state);

    /* Parser therml */
    therml_parse_chunk (parser, rbuf_str (therml), rbuf_len (therml), TRUE);

    /* Free and return */
    rarray_free (state->rnode_stack);
    rchunk_free (state, sizeof (RNodeThermlState));
    therml_parser_free (parser);
}



