
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __TMAIN_H__
#define __TMAIN_H__

typedef enum {
    TMAIN_READ      = 1 << 0,
    TMAIN_WRITE     = 1 << 1,
    TMAIN_ERROR     = 1 << 2
} TMainEventType;

typedef void (*TMainTimeoutEventFunction) (int id, void *user_data);

typedef void (*TMainFDEventFunction) (int id, int fd, TMainEventType event_type, void *user_data);

typedef void (*TMainSocketEventFunction) (int id, SOCKET socket, TMainEventType event_type, void *user_data);

typedef void (*TMainIdleEventFunction) (int id, void *user_data);


int
tmain_timeout_add (unsigned int ms, char *description, 
                   TMainTimeoutEventFunction function, void *user_data);

int
tmain_idle_add (char *description, TMainIdleEventFunction function, void *user_data);

int
tmain_fd_add (int fd, char *description, TMainEventType event_types, 
              TMainFDEventFunction function, void *user_data);

int
tmain_socket_add (SOCKET fd, char *description, TMainEventType event_types, 
                  TMainSocketEventFunction function, void *user_data);

/* Return description of id */
char *
tmain_description (int id);

void
tmain_remove (int id);

void
tmain_quit (void);

void
tmain (void);


#endif /* __TMAIN_H__ */


