
(define-api (database-connect path mode)
   (case mode
     ((read)
     	(read-database path))
     ((update)
        (open-database path))
    (else
      (error "invalid connect mode: ~s" mode))))

(define-api (make-database path db-name user-name fullname mail login-name login-host)
    (let* ((u (make <user>
    		   name: user-name
		   id: 0
		   full-name: fullname
		   email-addr: mail
		   remote-hosts: (list (list login-host login-name))
		   authorities: '()
		   properties: '((super-user . #t))
		   audit-log: '()))
	   (g (make <group>
	  	    name: "world"
		    id: 0
		    owner: u
		    audit-log: '()))
	   (a (make-application db-name)))
	;;
	(set-world-group! a g)
	(table-insert! (user-table a) (name u) u)
	(table-insert! (group-table a) (name g) g)
	(create-database a path)))

