
(define (date->weekday date)
  (vector-ref '#(sunday 
		 monday 
		 tuesday 
		 wednesday 
		 thursday 
		 friday 
		 saturday)
	      (remainder (date->day date) 7)))

(define (date->week (date <date>))
  (let ((day (date->day date)))
    (values (quotient day 7)
	    (remainder day 7))))

(define (week->date (week <fixnum>) (weekday <fixnum>))
  (if (and (fixnum>=? weekday 0)
	   (fixnum<? weekday 7))
      (day->date (+ (* week 7) weekday))
      (error "weekday `~d' out of range 0..6" weekday)))


(define (short-weekday-name weekday)
  (case weekday
    ((sunday) "Sun")
    ((monday) "Mon")
    ((tuesday) "Tue")
    ((wednesday) "Wed")
    ((thursday) "Thu")
    ((friday) "Fri")
    ((saturday) "Sat")
    (else "???")))
    
(define (short-month-name month)
    (vector-ref '#(#f 
    		   "Jan" "Feb" "Mar" "Apr"
    		   "May" "Jun" "Jul" "Aug"
		   "Sep" "Oct" "Nov" "Dec")
		month))
