
#include <stdio.h>

#import "RSSReaderToolbarDelegate.h"

#import "MyDelegate.h"
#import "RSSReaderAddWindowDelegate.h"
#import "RSSReaderRemWindowDelegate.h"

@implementation RSSReaderToolbarDelegate : NSObject


-init
{
  update = nil;
  addFeed = nil;
  remFeed = nil;
  jumpto = nil;
}

// returns a ToolbarItem of the kind identified by the
// itemIdentifier.

- (NSToolbarItem *) toolbar:(NSToolbar *) toolbar
      itemForItemIdentifier:(NSString *)itemIdentifier
  willBeInsertedIntoToolbar:(BOOL)flag
{
  printf ( "[x] toolbar: ...\n    itemForItemIdentifier: "
	   "%s\n    willBeInsertedIntoToolbar: %s\n",
	   [itemIdentifier cString],
	   (flag?"YES":"NO") );
  return [self getToolbarItemForIdentifier: itemIdentifier];
}


// just for help
- (NSToolbarItem *) getToolbarItemForIdentifier: (NSString*) itemIdentifier
{
  NSToolbarItem * item;
  
  item = nil; // default
  
  
  if ([itemIdentifier isEqualToString: @"update"])
    {
      if (update == nil)
	{
	  update = [[NSToolbarItem alloc]
		     initWithItemIdentifier: itemIdentifier];
	  [update setLabel: @"Update"];
	  [update setPaletteLabel: @"Fetch all feeds"];
	  [update setImage: [NSImage imageNamed: @"toolbar_refresh.png"]];
	  [update setTarget: self];
	  [update setAction: @selector(update:)];
	}
      
      item = update;
    }
  else if ([itemIdentifier isEqualToString: @"addFeed"])
    {
      if (addFeed == nil)
	{
	  addFeed = [[NSToolbarItem alloc]
		     initWithItemIdentifier: itemIdentifier];
	  [addFeed setLabel: @"Add Feed"];
	  [addFeed setPaletteLabel: @"Add a new feed"];
	  [addFeed setImage: [NSImage imageNamed: @"toolbar_add.png"]];
	  [addFeed setTarget: self];
	  [addFeed setAction: @selector(addFeed:)];
	}
      
      item = addFeed;
    }
  else if ([itemIdentifier isEqualToString: @"jumpto"])
    {
      if (jumpto == nil)
	{
	  jumpto = [[NSToolbarItem alloc]
		     initWithItemIdentifier: itemIdentifier];
	  [jumpto setLabel: @"Go there"];
	  [jumpto setPaletteLabel:
		    @"View the selected article in original form"];
	  [jumpto setImage: [NSImage imageNamed: @"toolbar_web.png"]];
	  [jumpto setTarget: self];
	  [jumpto setAction: @selector(jumpto:)];
	}
      
      item = jumpto;
    }
  else if ([itemIdentifier isEqualToString: @"remFeed"])
    {
      if (remFeed == nil)
	{
	  remFeed = [[NSToolbarItem alloc]
		     initWithItemIdentifier: itemIdentifier];
	  [remFeed setLabel: @"Remove Feed"];
	  [remFeed setPaletteLabel: @"Remove an existing feed"];
	  [remFeed setImage: [NSImage imageNamed: @"toolbar_remove.png"]];
	  [remFeed setTarget: self];
	  [remFeed setAction: @selector(remFeed:)];
	}
      
      item = remFeed;
    }
   
  return item;
}


#define QWINHEIGHT 100
#define QWINWIDTH  250
#define LABELHEIGHT 50
#define BUTTONHEIGHT 30

- remFeed: (NSNotification*) not
{
  NSWindow *win;
  NSButton *okay;
  NSButton *cancel;
  NSButton *buttons[2];
  NSTextField * label;
  NSView* content;
  RSSFeed* feed;
  RSSReaderRemWindowDelegate* delegate;
  int i;
  
  NSLog(@"remFeed clicked.");
  
  // get marked feed
  feed = [[[NSApp delegate] RSSFeeds] markedFeed];
  
  
  // create label
  label = [[NSTextField alloc]
	    initWithFrame:
	      NSMakeRect( 5, QWINHEIGHT-5-LABELHEIGHT,
			  QWINWIDTH-10, LABELHEIGHT )];
  
  [label setEditable: NO];
  [label setBezeled: NO];
  [label setDrawsBackground: NO];
  
  [label setStringValue:
    [NSString stringWithFormat:
       @"You are about to delete\n"
       @"the feed \"%@\".\n"
       @"Are you sure you want to do this?",
       [feed feedName] ]];

  // create two buttons (okay and cancel)
  for (i=0;i<2;i++)
    {
      buttons[i] = [[NSButton alloc] init];
      [buttons[i] setFrame:
		NSMakeRect(QWINWIDTH-60-i*60,
			   QWINHEIGHT-10-LABELHEIGHT-BUTTONHEIGHT,
			   55, BUTTONHEIGHT)];
    }
  
  okay = buttons[0];
  cancel = buttons[1];
  [okay setStringValue: @"Okay"];
  [cancel setStringValue: @"Cancel"];
  
  
  // create window
  win = [[NSWindow alloc]
	  initWithContentRect:
	    NSMakeRect(0,0, QWINWIDTH,QWINHEIGHT)
	  styleMask: NSTitledWindowMask
	  backing: NSBackingStoreBuffered
	  defer: NO
  ];
  
  [win setTitle: @"Really remove this feed?"];
  
  //FIXME: Do that delegate stuff? What can happen here?
  [win setDelegate: self];
  
  [win setReleasedWhenClosed: YES];
  
  [win center];
  [win orderFrontRegardless];
  [win makeKeyWindow]; // is this appropriate here?
  
  delegate = [[RSSReaderRemWindowDelegate alloc] init];
  [delegate setWindow: win];
  [delegate setFeed: feed];
  
  
  [okay setTarget: delegate];
  [okay setAction: @selector(okayClicked:)];
  [cancel setTarget: delegate];
  [cancel setAction: @selector(cancelClicked:)];
  
  
  // create the content view
  content = [[NSView alloc]
	      initWithFrame: NSMakeRect(0,0,QWINWIDTH, QWINHEIGHT)];
  
  // put the window together
  [win setContentView: content];
  for (i=0; i<2; i++)
    {
      [content addSubview: buttons[i]];
    }
  [content addSubview: label];
  
  [win display];
  
  return self;
}



- jumpto: (NSNotification*) not
{
  [[[NSApp delegate] RSSFeeds] viewSelected];
  return self;
}


#define DIALOGHEIGHT 136
#define DIALOGWIDTH  300

- addFeed: (NSNotification*) not
{
  NSWindow * win;
  NSView   * content;
  NSTextField *bin, *bins[2];
  NSTextField *label, *labels[2];
  NSButton *okbutton, *cancelbutton;
  NSButton *buttons[2];
  RSSReaderAddWindowDelegate* delegate;
  
  int i;
  
  for (i=0;i<2;i++)
    {
      // text field
      label = [[NSTextField alloc]
                    initWithFrame:
		      NSMakeRect(5, DIALOGHEIGHT-(50+i*40), 80, 30)];
      labels[i] = label;
      
      //[label setFont:[NSFont labelFontOfSize:
      //                             [[label font] pointSize]+8]];
      
      [label setEditable:NO];
      [label setBezeled: NO];
      [label setDrawsBackground: NO];
      
      
      // input widget
      bin = [NSTextField new];
      bins[i] = bin;
      
      [bin setFrame: NSMakeRect(90,DIALOGHEIGHT-(50+i*40), DIALOGWIDTH-95,30)];
      [bin setStringValue: @""]; // clear
      [bin setEditable: YES];
      [bin setAutoresizingMask:
	     (NSViewWidthSizable|
	      NSViewMinXMargin|NSViewMinYMargin)];
      
    }
  
  
  
  [labels[0] setStringValue: @"Feed URL"];
  [labels[1] setStringValue: @"Feed name"];
  
  
  for (i=0; i<2; i++)
    {
      buttons[i] = [[NSButton alloc] init];
      [buttons[i] setFrame:
		NSMakeRect(DIALOGWIDTH-60-i*60, DIALOGHEIGHT-(50+2*40),
			   55, 30)];
    }
  
  [buttons[1] setStringValue: @"Cancel"];
  [buttons[0] setStringValue: @"Okay"];
  cancelbutton = buttons[1];
  okbutton = buttons[0];
  
  content = [[NSView alloc]
	      initWithFrame: NSMakeRect(0,0,DIALOGWIDTH,DIALOGHEIGHT)];
  
  win = [[NSWindow alloc]
	  initWithContentRect:
	    NSMakeRect(100,100, DIALOGWIDTH,DIALOGHEIGHT)
	  styleMask: NSTitledWindowMask
	  backing: NSBackingStoreBuffered
	  defer: NO
  ];
  
  [win setTitle: @"Add a feed"];
  
  // FIXME: do that delegate stuff!
  [win setDelegate:self];
  
  [win setReleasedWhenClosed:YES];
  
  [win center];
  [win orderFrontRegardless];
  [win makeKeyWindow];
  
  // button delegate
  delegate = [[RSSReaderAddWindowDelegate alloc] init];
  [delegate setWindow: win];
  [delegate setUrlField: bins[0] nameField: bins[1]];
  
  // setting targets for buttons
  [okbutton setTarget: delegate];
  [okbutton setAction: @selector(okayClicked:)];
  [cancelbutton setTarget: delegate];
  [cancelbutton setAction: @selector(cancelClicked:)];
  

  
  [win setContentView:content];
  //RELEASE(content);
  
  for (i=0; i<2; i++)
    {
      [content addSubview: bins[i]];
      [content addSubview: labels[i]];
      [content addSubview: buttons[i]];
    }
  
  [win display];
  
  // rrr end
  return self;
}



- update: (NSNotification*) not
{
  MyDelegate* delegate;
  
#ifdef DEBUG
  NSLog(@"update pressed.");
#endif
  
  delegate = [NSApp delegate];
  [[delegate RSSFeeds] updateAllFeeds];
  [delegate reloadTable];
  
  return self;
}


// Returns an array of ToolbarItem identifiers. (Strings)

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
  return [NSArray arrayWithObjects:
		    //NSToolbarSeparatorItemIdentifier,
		    NSToolbarSpaceItemIdentifier,
		  NSToolbarFlexibleSpaceItemIdentifier,
		  NSToolbarCustomizeToolbarItemIdentifier, 
		  @"update", @"addFeed", @"remFeed", @"jumpto",
		  nil];
}



// Returns an array of default ToolbarItem identifiers.

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
  return [NSArray arrayWithObjects:
		    @"update",
		  NSToolbarSpaceItemIdentifier,
		  @"addFeed", @"remFeed",
		  NSToolbarSpaceItemIdentifier,
		  @"jumpto",
		  NSToolbarFlexibleSpaceItemIdentifier,
		  nil];
}

@end
