/***************************************************************************
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   Licensed under the GNU GPL                                            *
 *   Original code supplied under license from RaLink Inc, 2003.           *
 ***************************************************************************/

 /***************************************************************************
 *      Module Name: rt_config.h
 *
 *      Abstract: Central header file to maintain all include files for all
 *                NDIS miniport driver routines
 *
 *      Revision History:
 *      Who             When            What
 *      --------        -----------     -----------------------------
 *      RoryC           21st Dec 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      Ivo 		27th Jun 04     Fixed Wireless Exts iport for ioctl
 ***************************************************************************/


#ifndef	__RT_CONFIG_H__
#define	__RT_CONFIG_H__

#define	DRV_NAME	"rt2400"
#define DRV_VERSION	"1.2.2 - CVS"
#define DRV_RELDATE	"CVS Release"

/* Keep these in sync with the strings above */
#define DRV_VERSION_MAJOR 1
#define DRV_VERSION_MINOR 2
#define DRV_VERSION_SUB   2
#define DRV_BUILD_YEAR    2005
#define DRV_BUILD_MONTH   7
#define DRV_BUILD_DAY     11

#define	PROFILE_PATH	"/etc/Ralink/RT2400/RT2400.dat"

/* Operational parameters that are set at compile time. */
#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error  You must compile this driver with "-O".
#endif

#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,25))	// N.A. earlier
#include <linux/moduleparam.h>	// Only need to explicitly include
#endif							// in early 2.6 series
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>		// For udelay, mdelay
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/if_arp.h>

#if LINUX_VERSION_CODE >= 0x20407
#include <linux/mii.h>
#endif
#include <asm/processor.h>      /* Processor type for cache alignment. */
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,25)
/* 2.6 compatibility */
#define SET_NETDEV_DEV(net, pdev) do { } while (0)
#endif

#ifndef pci_name
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
#define pci_name(__pPci_Dev)	(__pPci_Dev)->dev.bus_id
#else /* (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)) */
#define pci_name(__pPci_Dev)	(__pPci_Dev)->slot_name
#endif /*(LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)) */
#endif /* pci_name */

// 2.5.44? 2.5.26?
#ifndef smp_read_barrier_depends
#define smp_read_barrier_depends() ((void)0)
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18))
#define IRQFLAGS SA_SHIRQ
#else
#define IRQFLAGS IRQF_SHARED
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,22))
#define pci_module_init	pci_register_driver
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22))
#define skb_reset_mac_header(skb) (skb->mac.raw = skb->data)
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,24))
#define SET_MODULE_OWNER(some_struct) do { } while (0)
#define dev_get_by_name(slot_name) dev_get_by_name(&init_net, slot_name)
#define first_net_device() first_net_device(&init_net)
#endif

#if WIRELESS_EXT > 12
#include <net/iw_handler.h> /* New driver API */
#endif /* WIRELESS_EXT > 12 */

// The type definition has to be placed before including rt2460.h
#ifndef ULONG
#define	CHAR			signed char
#define	INT				int
#define	UINT			u32
#define ULONG			u32
#define USHORT			u16
#define UCHAR			u8

#define BOOLEAN			u8
#define LARGE_INTEGER	s64
#define VOID			void
#define	LONG			int
#define ULONGLONG		u64
typedef VOID	*PVOID;
typedef CHAR	*PCHAR;
typedef UCHAR	*PUCHAR;
typedef LONG	*PLONG;
#endif

#define	IN
#define	OUT

#define TRUE		1
#define FALSE		0

#define	NDIS_STATUS				INT
#define	NDIS_STATUS_SUCCESS		0x00
#define NDIS_STATUS_FAILURE		0x01
#define	NDIS_STATUS_RESOURCES	0x03

#include	"rt2460.h"
#include	"rtmp_def.h"
#include	"rtmp.h"
#include	"rt2x00debug.h"
#include	"mlme.h"
#include	"oid.h"

#endif // __RT_CONFIG_H__
