# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::SQL
  module Models
    #
    # Represents an Azure SQL Database Service Objective.
    #
    class ServiceObjective < SqlSubResource

      include MsRestAzure

      # @return [String] The name for the service objective.
      attr_accessor :service_objective_name

      # @return [Boolean] Gets whether the service level objective is the
      # default service objective.
      attr_accessor :is_default

      # @return [Boolean] Gets whether the service level objective is a system
      # service objective.
      attr_accessor :is_system

      # @return [String] The description for the service level objective.
      attr_accessor :description

      # @return [Boolean] Gets whether the service level objective is enabled.
      attr_accessor :enabled


      #
      # Mapper for ServiceObjective class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ServiceObjective',
          type: {
            name: 'Composite',
            class_name: 'ServiceObjective',
            model_properties: {
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              service_objective_name: {
                required: false,
                read_only: true,
                serialized_name: 'properties.serviceObjectiveName',
                type: {
                  name: 'String'
                }
              },
              is_default: {
                required: false,
                read_only: true,
                serialized_name: 'properties.isDefault',
                type: {
                  name: 'Boolean'
                }
              },
              is_system: {
                required: false,
                read_only: true,
                serialized_name: 'properties.isSystem',
                type: {
                  name: 'Boolean'
                }
              },
              description: {
                required: false,
                read_only: true,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              enabled: {
                required: false,
                read_only: true,
                serialized_name: 'properties.enabled',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
