
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ar/gherkin_lexer_ar.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 13, 19, 21, 22, 23, 24, 
	25, 26, 27, 29, 31, 43, 46, 47, 
	48, 49, 50, 51, 52, 53, 54, 55, 
	56, 58, 60, 65, 70, 75, 80, 84, 
	88, 90, 91, 92, 93, 94, 95, 96, 
	97, 98, 99, 100, 101, 102, 103, 104, 
	105, 110, 117, 122, 126, 132, 135, 137, 
	143, 155, 157, 158, 159, 160, 161, 162, 
	163, 164, 165, 166, 167, 168, 169, 170, 
	180, 187, 189, 191, 193, 195, 197, 199, 
	201, 213, 215, 217, 219, 221, 223, 225, 
	227, 229, 231, 233, 235, 237, 239, 241, 
	243, 245, 247, 249, 251, 253, 255, 257, 
	259, 261, 263, 265, 267, 269, 271, 274, 
	276, 278, 280, 282, 284, 286, 288, 290, 
	292, 294, 296, 298, 300, 302, 304, 306, 
	310, 312, 314, 316, 318, 320, 322, 324, 
	326, 328, 330, 332, 334, 336, 338, 340, 
	342, 344, 346, 348, 350, 352, 354, 355, 
	356, 357, 358, 359, 360, 361, 362, 363, 
	370, 372, 374, 376, 378, 380, 382, 384, 
	386, 388, 390, 391, 392, 393, 394, 395, 
	396, 397, 398, 399, 400, 401, 402, 403, 
	404, 405, 406, 407, 408, 409, 417, 421, 
	423, 426, 428, 430, 432, 434, 436, 438, 
	440, 442, 444, 446, 448, 450, 452, 454, 
	456, 458, 460, 462, 464, 466, 468, 470, 
	472, 474, 476, 478, 480, 482, 484, 486, 
	488, 491, 493, 495, 497, 499, 501, 503, 
	505, 507, 509, 511, 513, 515, 517, 519, 
	521, 523, 525, 527, 529, 531, 533, 535, 
	536, 537, 538, 539, 540, 541, 542, 543, 
	544, 545, 546, 547, 549, 550, 551, 552, 
	553, 554, 555, 556, 557, 558, 559, 560, 
	570, 577, 579, 581, 583, 585, 587, 589, 
	591, 593, 595, 597, 599, 601, 603, 605, 
	607, 609, 611, 613, 615, 617, 619, 621, 
	623, 625, 627, 629, 631, 633, 635, 637, 
	639, 641, 643, 645, 647, 649, 651, 653, 
	655, 657, 659, 661, 663, 665, 669, 671, 
	673, 675, 677, 679, 681, 683, 685, 687, 
	689, 691, 693, 695, 697, 699, 701, 703, 
	705, 707, 709, 711, 713, 714, 715, 725, 
	732, 735, 737, 739, 741, 743, 745, 747, 
	749, 751, 753, 755, 757, 759, 761, 763, 
	765, 767, 769, 771, 773, 775, 777, 779, 
	781, 783, 785, 787, 789, 791, 793, 795, 
	797, 799, 801, 803, 805, 807, 809, 811, 
	813, 815, 817, 819, 822, 824, 826, 828, 
	830, 832, 834, 836, 838, 840, 842, 844, 
	846, 848, 850, 852, 854, 858, 860, 862, 
	864, 866, 868, 870, 872, 874, 876, 878, 
	880, 882, 884, 886, 888, 890, 892, 894, 
	896, 898, 900, 902, 903, 904, 905, 906, 
	907, 908, 909, 910, 911, 912
};

static const char _lexer_trans_keys[] = {
	-40, -39, -17, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -89, -88, -85, 
	-82, -77, -71, -40, -39, -80, -40, -89, 
	-39, -117, 32, 10, 13, 10, 13, -40, 
	-39, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -124, -123, -120, -39, -125, 
	-39, -122, -40, -86, -39, -119, 34, 34, 
	10, 13, 10, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -40, 
	-39, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -124, -123, -40, -82, -39, 
	-124, -39, -127, -39, -118, -40, -87, 58, 
	10, 10, -40, -39, 10, 32, 35, 37, 
	42, 64, 9, 13, -89, -88, -85, -82, 
	-77, -71, 10, -40, 10, -80, 10, -40, 
	10, -89, 10, -39, 10, -117, 10, 10, 
	32, -40, -39, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -39, 10, -127, 
	10, -40, 10, -79, 10, -40, 10, -74, 
	10, -39, 10, -123, 10, -40, 10, -89, 
	10, -40, 10, -75, 10, -39, 10, -118, 
	10, -40, 10, -87, 10, 10, 58, -39, 
	10, -118, 10, -39, 10, -122, 10, -40, 
	10, -89, 10, -40, 10, -79, 10, -39, 
	10, -118, 10, -39, 10, -120, 10, 10, 
	32, 58, -39, 10, -123, 10, -40, 10, 
	-82, 10, -40, 10, -73, 10, -40, 10, 
	-73, 10, -39, 10, -122, 10, -40, 10, 
	-81, 10, -39, 10, -123, 10, -40, 10, 
	-89, 10, -124, -123, -120, 10, -39, 10, 
	-125, 10, -39, 10, -122, 10, -40, 10, 
	-86, 10, -39, 10, -119, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -40, -85, -39, -124, -40, -87, 
	58, 10, 10, -40, 10, 32, 35, 124, 
	9, 13, -82, 10, -40, 10, -89, 10, 
	-40, 10, -75, 10, -39, 10, -118, 10, 
	-40, 10, -87, 10, 10, 58, -39, -127, 
	-40, -79, -40, -74, -39, -123, -40, -89, 
	-40, -75, -39, -118, -40, -87, 58, 10, 
	10, -40, 10, 32, 35, 37, 64, 9, 
	13, -89, -82, -77, 10, -39, 10, -124, 
	-123, 10, -40, 10, -82, 10, -39, 10, 
	-124, 10, -39, 10, -127, 10, -39, 10, 
	-118, 10, -40, 10, -87, 10, 10, 58, 
	-40, 10, -85, 10, -39, 10, -124, 10, 
	-40, 10, -89, 10, -40, 10, -75, 10, 
	-39, 10, -118, 10, -39, 10, -122, 10, 
	-40, 10, -89, 10, -40, 10, -79, 10, 
	-39, 10, -118, 10, -39, 10, -120, 10, 
	10, 32, 58, -39, 10, -123, 10, -40, 
	10, -82, 10, -40, 10, -73, 10, -40, 
	10, -73, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -39, 
	-118, -39, -122, -40, -89, -40, -79, -39, 
	-118, -39, -120, 32, 58, -39, -123, -40, 
	-82, -40, -73, -40, -73, 58, 10, 10, 
	-40, -39, 10, 32, 35, 37, 42, 64, 
	9, 13, -89, -88, -85, -82, -77, -71, 
	10, -40, 10, -80, 10, -40, 10, -89, 
	10, -39, 10, -117, 10, 10, 32, -39, 
	10, -127, 10, -40, 10, -79, 10, -40, 
	10, -74, 10, -39, 10, -123, 10, -40, 
	10, -89, 10, -40, 10, -75, 10, -39, 
	10, -118, 10, -40, 10, -87, 10, 10, 
	58, -39, 10, -118, 10, -39, 10, -122, 
	10, -40, 10, -89, 10, -40, 10, -79, 
	10, -39, 10, -118, 10, -39, 10, -120, 
	10, -39, 10, -122, 10, -40, 10, -81, 
	10, -39, 10, -123, 10, -40, 10, -89, 
	10, -124, -123, -120, 10, -39, 10, -125, 
	10, -39, 10, -122, 10, -40, 10, -86, 
	10, -39, 10, -119, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, 10, 10, -40, -39, 10, 32, 35, 
	37, 42, 64, 9, 13, -89, -88, -85, 
	-82, -77, -71, 10, -40, -39, 10, -80, 
	10, -40, 10, -89, 10, -39, 10, -117, 
	10, 10, 32, -124, 10, -40, 10, -82, 
	10, -39, 10, -124, 10, -39, 10, -127, 
	10, -39, 10, -118, 10, -40, 10, -87, 
	10, 10, 58, -39, 10, -127, 10, -40, 
	10, -79, 10, -40, 10, -74, 10, -39, 
	10, -123, 10, -40, 10, -89, 10, -40, 
	10, -75, 10, -39, 10, -118, 10, -39, 
	10, -122, 10, -40, 10, -89, 10, -40, 
	10, -79, 10, -39, 10, -118, 10, -39, 
	10, -120, 10, 10, 32, 58, -39, 10, 
	-123, 10, -40, 10, -82, 10, -40, 10, 
	-73, 10, -40, 10, -73, 10, -39, 10, 
	-122, 10, -40, 10, -81, 10, -39, 10, 
	-123, 10, -40, 10, -89, 10, -124, -123, 
	-120, 10, -39, 10, -125, 10, -39, 10, 
	-122, 10, -40, 10, -86, 10, -39, 10, 
	-119, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -39, -122, 
	-40, -81, -39, -123, -40, -89, -69, -65, 
	0
};

static const char _lexer_single_lengths[] = {
	0, 11, 6, 2, 1, 1, 1, 1, 
	1, 1, 2, 2, 10, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	10, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 8, 
	7, 2, 2, 2, 2, 2, 2, 2, 
	10, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 5, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 6, 4, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 8, 
	7, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 8, 7, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 13, 20, 23, 25, 27, 29, 
	31, 33, 35, 38, 41, 53, 57, 59, 
	61, 63, 65, 67, 69, 71, 73, 75, 
	77, 80, 83, 88, 93, 98, 103, 107, 
	111, 114, 116, 118, 120, 122, 124, 126, 
	128, 130, 132, 134, 136, 138, 140, 142, 
	144, 149, 156, 161, 165, 171, 175, 178, 
	184, 196, 199, 201, 203, 205, 207, 209, 
	211, 213, 215, 217, 219, 221, 223, 225, 
	235, 243, 246, 249, 252, 255, 258, 261, 
	264, 276, 279, 282, 285, 288, 291, 294, 
	297, 300, 303, 306, 309, 312, 315, 318, 
	321, 324, 327, 330, 333, 336, 339, 342, 
	345, 348, 351, 354, 357, 360, 363, 367, 
	370, 373, 376, 379, 382, 385, 388, 391, 
	394, 397, 400, 403, 406, 409, 412, 415, 
	420, 423, 426, 429, 432, 435, 438, 441, 
	444, 447, 450, 453, 456, 459, 462, 465, 
	468, 471, 474, 477, 480, 483, 486, 488, 
	490, 492, 494, 496, 498, 500, 502, 504, 
	511, 514, 517, 520, 523, 526, 529, 532, 
	535, 538, 541, 543, 545, 547, 549, 551, 
	553, 555, 557, 559, 561, 563, 565, 567, 
	569, 571, 573, 575, 577, 579, 587, 592, 
	595, 599, 602, 605, 608, 611, 614, 617, 
	620, 623, 626, 629, 632, 635, 638, 641, 
	644, 647, 650, 653, 656, 659, 662, 665, 
	668, 671, 674, 677, 680, 683, 686, 689, 
	692, 696, 699, 702, 705, 708, 711, 714, 
	717, 720, 723, 726, 729, 732, 735, 738, 
	741, 744, 747, 750, 753, 756, 759, 762, 
	764, 766, 768, 770, 772, 774, 776, 778, 
	780, 782, 784, 786, 789, 791, 793, 795, 
	797, 799, 801, 803, 805, 807, 809, 811, 
	821, 829, 832, 835, 838, 841, 844, 847, 
	850, 853, 856, 859, 862, 865, 868, 871, 
	874, 877, 880, 883, 886, 889, 892, 895, 
	898, 901, 904, 907, 910, 913, 916, 919, 
	922, 925, 928, 931, 934, 937, 940, 943, 
	946, 949, 952, 955, 958, 961, 966, 969, 
	972, 975, 978, 981, 984, 987, 990, 993, 
	996, 999, 1002, 1005, 1008, 1011, 1014, 1017, 
	1020, 1023, 1026, 1029, 1032, 1034, 1036, 1046, 
	1054, 1058, 1061, 1064, 1067, 1070, 1073, 1076, 
	1079, 1082, 1085, 1088, 1091, 1094, 1097, 1100, 
	1103, 1106, 1109, 1112, 1115, 1118, 1121, 1124, 
	1127, 1130, 1133, 1136, 1139, 1142, 1145, 1148, 
	1151, 1154, 1157, 1160, 1163, 1166, 1169, 1172, 
	1175, 1178, 1181, 1184, 1188, 1191, 1194, 1197, 
	1200, 1203, 1206, 1209, 1212, 1215, 1218, 1221, 
	1224, 1227, 1230, 1233, 1236, 1241, 1244, 1247, 
	1250, 1253, 1256, 1259, 1262, 1265, 1268, 1271, 
	1274, 1277, 1280, 1283, 1286, 1289, 1292, 1295, 
	1298, 1301, 1304, 1307, 1309, 1311, 1313, 1315, 
	1317, 1319, 1321, 1323, 1325, 1327
};

static const short _lexer_trans_targs[] = {
	2, 13, 435, 12, 12, 22, 32, 34, 
	9, 48, 51, 12, 0, 3, 170, 176, 
	178, 247, 427, 0, 4, 57, 0, 5, 
	0, 6, 0, 7, 0, 8, 0, 9, 
	0, 10, 0, 12, 33, 11, 12, 33, 
	11, 2, 13, 12, 12, 22, 32, 34, 
	9, 48, 51, 12, 0, 14, 18, 9, 
	0, 15, 0, 16, 0, 17, 0, 9, 
	0, 19, 0, 20, 0, 21, 0, 9, 
	0, 23, 0, 24, 0, 26, 25, 25, 
	26, 25, 25, 27, 27, 28, 27, 27, 
	27, 27, 28, 27, 27, 27, 27, 29, 
	27, 27, 27, 27, 30, 27, 27, 12, 
	31, 31, 0, 12, 31, 31, 0, 12, 
	33, 32, 12, 0, 35, 0, 36, 0, 
	37, 0, 38, 0, 39, 0, 40, 0, 
	41, 0, 42, 0, 43, 0, 44, 0, 
	45, 0, 46, 0, 47, 0, 437, 0, 
	0, 0, 0, 0, 49, 50, 12, 50, 
	50, 48, 49, 49, 12, 50, 48, 50, 
	0, 51, 52, 51, 0, 56, 55, 54, 
	52, 55, 53, 0, 54, 52, 53, 0, 
	54, 53, 56, 55, 54, 52, 55, 53, 
	2, 13, 56, 56, 22, 32, 34, 9, 
	48, 51, 56, 0, 58, 150, 0, 59, 
	0, 60, 0, 61, 0, 62, 0, 63, 
	0, 64, 0, 65, 0, 66, 0, 67, 
	0, 68, 0, 69, 0, 71, 70, 71, 
	70, 72, 127, 71, 71, 12, 136, 79, 
	12, 71, 70, 73, 81, 87, 89, 98, 
	119, 71, 70, 74, 71, 70, 75, 71, 
	70, 76, 71, 70, 77, 71, 70, 78, 
	71, 70, 79, 71, 70, 71, 80, 70, 
	2, 13, 12, 12, 22, 32, 34, 9, 
	48, 51, 12, 0, 82, 71, 70, 83, 
	71, 70, 84, 71, 70, 85, 71, 70, 
	86, 71, 70, 79, 71, 70, 88, 71, 
	70, 79, 71, 70, 90, 71, 70, 91, 
	71, 70, 92, 71, 70, 93, 71, 70, 
	94, 71, 70, 95, 71, 70, 96, 71, 
	70, 97, 71, 70, 71, 80, 70, 99, 
	71, 70, 100, 71, 70, 101, 71, 70, 
	102, 71, 70, 103, 71, 70, 104, 71, 
	70, 105, 71, 70, 106, 71, 70, 107, 
	71, 70, 108, 71, 70, 109, 71, 70, 
	110, 71, 70, 71, 111, 80, 70, 112, 
	71, 70, 113, 71, 70, 114, 71, 70, 
	115, 71, 70, 116, 71, 70, 117, 71, 
	70, 118, 71, 70, 97, 71, 70, 120, 
	71, 70, 121, 71, 70, 122, 71, 70, 
	123, 71, 70, 124, 71, 70, 125, 71, 
	70, 126, 71, 70, 79, 71, 70, 128, 
	132, 79, 71, 70, 129, 71, 70, 130, 
	71, 70, 131, 71, 70, 79, 71, 70, 
	133, 71, 70, 134, 71, 70, 135, 71, 
	70, 79, 71, 70, 71, 137, 70, 71, 
	138, 70, 71, 139, 70, 71, 140, 70, 
	71, 141, 70, 71, 142, 70, 71, 143, 
	70, 71, 144, 70, 71, 145, 70, 71, 
	146, 70, 71, 147, 70, 71, 148, 70, 
	71, 149, 70, 71, 12, 70, 151, 0, 
	152, 0, 153, 0, 154, 0, 155, 0, 
	156, 0, 157, 0, 159, 158, 159, 158, 
	160, 159, 159, 12, 12, 159, 158, 161, 
	159, 158, 162, 159, 158, 163, 159, 158, 
	164, 159, 158, 165, 159, 158, 166, 159, 
	158, 167, 159, 158, 168, 159, 158, 169, 
	159, 158, 159, 80, 158, 171, 0, 172, 
	0, 173, 0, 174, 0, 175, 0, 9, 
	0, 177, 0, 9, 0, 179, 0, 180, 
	0, 181, 0, 182, 0, 183, 0, 184, 
	0, 185, 0, 186, 0, 187, 0, 189, 
	188, 189, 188, 190, 189, 189, 12, 233, 
	12, 189, 188, 191, 208, 212, 189, 188, 
	192, 189, 188, 193, 204, 189, 188, 194, 
	189, 188, 195, 189, 188, 196, 189, 188, 
	197, 189, 188, 198, 189, 188, 199, 189, 
	188, 200, 189, 188, 201, 189, 188, 202, 
	189, 188, 203, 189, 188, 189, 80, 188, 
	205, 189, 188, 206, 189, 188, 207, 189, 
	188, 201, 189, 188, 209, 189, 188, 210, 
	189, 188, 211, 189, 188, 199, 189, 188, 
	213, 189, 188, 214, 189, 188, 215, 189, 
	188, 216, 189, 188, 217, 189, 188, 218, 
	189, 188, 219, 189, 188, 220, 189, 188, 
	221, 189, 188, 222, 189, 188, 223, 189, 
	188, 224, 189, 188, 189, 225, 80, 188, 
	226, 189, 188, 227, 189, 188, 228, 189, 
	188, 229, 189, 188, 230, 189, 188, 231, 
	189, 188, 232, 189, 188, 203, 189, 188, 
	189, 234, 188, 189, 235, 188, 189, 236, 
	188, 189, 237, 188, 189, 238, 188, 189, 
	239, 188, 189, 240, 188, 189, 241, 188, 
	189, 242, 188, 189, 243, 188, 189, 244, 
	188, 189, 245, 188, 189, 246, 188, 189, 
	12, 188, 248, 0, 249, 0, 250, 0, 
	251, 0, 252, 0, 253, 0, 254, 0, 
	255, 0, 256, 0, 257, 0, 258, 0, 
	259, 0, 260, 340, 0, 261, 0, 262, 
	0, 263, 0, 264, 0, 265, 0, 266, 
	0, 267, 0, 268, 0, 269, 0, 271, 
	270, 271, 270, 272, 317, 271, 271, 12, 
	326, 279, 12, 271, 270, 273, 280, 286, 
	288, 297, 309, 271, 270, 274, 271, 270, 
	275, 271, 270, 276, 271, 270, 277, 271, 
	270, 278, 271, 270, 279, 271, 270, 271, 
	80, 270, 281, 271, 270, 282, 271, 270, 
	283, 271, 270, 284, 271, 270, 285, 271, 
	270, 279, 271, 270, 287, 271, 270, 279, 
	271, 270, 289, 271, 270, 290, 271, 270, 
	291, 271, 270, 292, 271, 270, 293, 271, 
	270, 294, 271, 270, 295, 271, 270, 296, 
	271, 270, 271, 80, 270, 298, 271, 270, 
	299, 271, 270, 300, 271, 270, 301, 271, 
	270, 302, 271, 270, 303, 271, 270, 304, 
	271, 270, 305, 271, 270, 306, 271, 270, 
	307, 271, 270, 308, 271, 270, 296, 271, 
	270, 310, 271, 270, 311, 271, 270, 312, 
	271, 270, 313, 271, 270, 314, 271, 270, 
	315, 271, 270, 316, 271, 270, 279, 271, 
	270, 318, 322, 279, 271, 270, 319, 271, 
	270, 320, 271, 270, 321, 271, 270, 279, 
	271, 270, 323, 271, 270, 324, 271, 270, 
	325, 271, 270, 279, 271, 270, 271, 327, 
	270, 271, 328, 270, 271, 329, 270, 271, 
	330, 270, 271, 331, 270, 271, 332, 270, 
	271, 333, 270, 271, 334, 270, 271, 335, 
	270, 271, 336, 270, 271, 337, 270, 271, 
	338, 270, 271, 339, 270, 271, 12, 270, 
	342, 341, 342, 341, 343, 404, 342, 342, 
	12, 413, 350, 12, 342, 341, 344, 363, 
	369, 371, 375, 396, 342, 341, 345, 351, 
	342, 341, 346, 342, 341, 347, 342, 341, 
	348, 342, 341, 349, 342, 341, 350, 342, 
	341, 342, 80, 341, 352, 342, 341, 353, 
	342, 341, 354, 342, 341, 355, 342, 341, 
	356, 342, 341, 357, 342, 341, 358, 342, 
	341, 359, 342, 341, 360, 342, 341, 361, 
	342, 341, 362, 342, 341, 342, 80, 341, 
	364, 342, 341, 365, 342, 341, 366, 342, 
	341, 367, 342, 341, 368, 342, 341, 350, 
	342, 341, 370, 342, 341, 350, 342, 341, 
	372, 342, 341, 373, 342, 341, 374, 342, 
	341, 358, 342, 341, 376, 342, 341, 377, 
	342, 341, 378, 342, 341, 379, 342, 341, 
	380, 342, 341, 381, 342, 341, 382, 342, 
	341, 383, 342, 341, 384, 342, 341, 385, 
	342, 341, 386, 342, 341, 387, 342, 341, 
	342, 388, 80, 341, 389, 342, 341, 390, 
	342, 341, 391, 342, 341, 392, 342, 341, 
	393, 342, 341, 394, 342, 341, 395, 342, 
	341, 362, 342, 341, 397, 342, 341, 398, 
	342, 341, 399, 342, 341, 400, 342, 341, 
	401, 342, 341, 402, 342, 341, 403, 342, 
	341, 350, 342, 341, 405, 409, 350, 342, 
	341, 406, 342, 341, 407, 342, 341, 408, 
	342, 341, 350, 342, 341, 410, 342, 341, 
	411, 342, 341, 412, 342, 341, 350, 342, 
	341, 342, 414, 341, 342, 415, 341, 342, 
	416, 341, 342, 417, 341, 342, 418, 341, 
	342, 419, 341, 342, 420, 341, 342, 421, 
	341, 342, 422, 341, 342, 423, 341, 342, 
	424, 341, 342, 425, 341, 342, 426, 341, 
	342, 12, 341, 428, 0, 429, 0, 430, 
	0, 431, 0, 432, 0, 433, 0, 434, 
	0, 9, 0, 436, 0, 12, 0, 0, 
	0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 29, 0, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 0, 0, 
	0, 0, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 149, 126, 57, 110, 23, 
	0, 29, 29, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 139, 48, 9, 
	106, 11, 0, 134, 45, 45, 45, 3, 
	122, 33, 33, 33, 0, 122, 33, 33, 
	33, 0, 122, 33, 0, 33, 0, 102, 
	7, 7, 43, 54, 0, 0, 43, 114, 
	25, 0, 54, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	43, 43, 43, 43, 0, 27, 118, 27, 
	27, 51, 27, 0, 54, 0, 1, 0, 
	43, 0, 0, 0, 43, 54, 37, 37, 
	87, 37, 37, 43, 0, 39, 0, 43, 
	0, 0, 54, 0, 0, 39, 0, 0, 
	96, 96, 54, 0, 93, 90, 41, 96, 
	90, 99, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 84, 54, 0, 72, 33, 84, 
	72, 0, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 15, 0, 
	63, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 15, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 15, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 54, 0, 81, 81, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 21, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 69, 33, 
	69, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 84, 54, 0, 78, 
	33, 84, 78, 0, 0, 0, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	19, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	144, 57, 54, 0, 84, 84, 54, 0, 
	75, 33, 84, 75, 0, 0, 0, 0, 
	0, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 437;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1036 "ext/gherkin_lexer_ar/gherkin_lexer_ar.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
    
#line 1043 "ext/gherkin_lexer_ar/gherkin_lexer_ar.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1333 "ext/gherkin_lexer_ar/gherkin_lexer_ar.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1396 "ext/gherkin_lexer_ar/gherkin_lexer_ar.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ar.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ar()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ar", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

