
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 34, 
	36, 47, 48, 49, 51, 53, 58, 63, 
	68, 73, 77, 81, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	95, 96, 97, 98, 103, 110, 115, 119, 
	125, 128, 130, 136, 147, 148, 149, 150, 
	151, 152, 153, 154, 155, 156, 157, 158, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 171, 172, 173, 174, 175, 
	176, 177, 178, 179, 188, 197, 199, 201, 
	203, 205, 207, 209, 211, 213, 215, 217, 
	219, 230, 232, 234, 236, 238, 240, 242, 
	244, 246, 248, 250, 252, 254, 256, 258, 
	260, 262, 264, 266, 268, 270, 272, 274, 
	276, 278, 280, 282, 284, 286, 288, 290, 
	292, 294, 296, 298, 300, 302, 304, 306, 
	308, 310, 312, 314, 316, 318, 320, 322, 
	324, 326, 328, 330, 332, 334, 336, 338, 
	340, 342, 344, 346, 348, 350, 352, 354, 
	356, 358, 360, 362, 364, 366, 368, 370, 
	372, 374, 376, 378, 380, 382, 384, 386, 
	388, 389, 390, 391, 392, 393, 394, 395, 
	396, 397, 398, 399, 406, 408, 410, 412, 
	414, 416, 418, 420, 422, 424, 426, 428, 
	430, 432, 434, 436, 438, 440, 442, 444, 
	446, 448, 450, 452, 454, 456, 458, 460, 
	462, 463, 464, 465, 466, 467, 468, 469, 
	470, 471, 472, 473, 474, 475, 476, 477, 
	478, 479, 480, 481, 482, 483, 484, 485, 
	486, 487, 488, 489, 490, 491, 492, 493, 
	494, 495, 504, 512, 514, 516, 518, 520, 
	522, 524, 526, 528, 530, 532, 534, 536, 
	538, 540, 542, 544, 546, 548, 550, 552, 
	554, 556, 558, 560, 562, 564, 566, 568, 
	570, 572, 574, 576, 578, 580, 582, 584, 
	586, 588, 590, 592, 594, 596, 598, 600, 
	602, 604, 606, 608, 610, 612, 614, 616, 
	618, 620, 622, 624, 626, 628, 630, 632, 
	634, 636, 638, 640, 642, 644, 646, 648, 
	650, 652, 654, 656, 658, 660, 661, 662, 
	663, 664, 665, 666, 667, 668, 669, 670, 
	671, 672, 673, 674, 675, 676, 677, 686, 
	696, 698, 700, 702, 704, 706, 708, 710, 
	712, 714, 716, 718, 720, 722, 724, 726, 
	728, 730, 732, 734, 736, 738, 740, 742, 
	744, 746, 748, 750, 752, 754, 756, 758, 
	760, 762, 764, 766, 768, 770, 772, 774, 
	776, 778, 780, 782, 784, 786, 788, 790, 
	792, 794, 796, 798, 800, 802, 804, 806, 
	808, 810, 812, 814, 816, 818, 820, 822, 
	824, 826, 828, 830, 832, 834, 836, 838, 
	840, 842, 844, 846, 848, 850, 852, 854, 
	856, 858, 860, 862, 864, 866, 868, 870, 
	872, 874, 876, 878, 880, 882, 884, 886, 
	888, 890, 892, 894, 896, 898, 900, 902, 
	904, 906, 908, 910, 912, 914, 916, 917, 
	918, 919, 920, 921, 922, 923, 924, 925, 
	926, 927, 928, 929, 930, 931, 932, 933, 
	934, 935, 936, 937, 938, 939, 940, 941, 
	942, 943, 944, 945, 953, 958, 960, 962, 
	964, 967, 969, 971, 973, 975, 977, 979, 
	981, 983, 985, 987, 989, 991, 993, 995, 
	997, 999, 1001, 1003, 1005, 1007, 1009, 1011, 
	1013, 1015, 1017, 1019, 1021, 1023, 1025, 1027, 
	1029, 1031, 1033, 1035, 1037, 1039, 1041, 1043, 
	1045, 1047, 1049, 1051, 1053, 1055, 1057, 1059, 
	1061, 1063, 1065, 1067, 1069, 1071, 1073, 1075, 
	1077, 1079, 1081, 1083, 1085, 1087, 1089, 1091, 
	1093, 1095, 1097, 1099, 1101, 1103, 1105, 1107, 
	1109, 1111, 1113, 1115, 1117, 1119, 1121, 1123, 
	1125, 1127, 1129, 1131, 1133, 1135, 1137, 1139, 
	1141, 1143, 1145, 1147, 1149, 1151, 1153, 1155, 
	1157, 1158, 1159
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -108, -104, -102, -99, 
	-97, -96, -95, -94, -92, -48, -80, -48, 
	-76, -48, -75, -48, -67, -48, -66, 32, 
	10, 13, 10, 13, -48, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, 34, 
	34, 10, 13, 10, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 9, 13, 10, 32, 9, 
	13, 10, 13, 10, 95, 70, 69, 65, 
	84, 85, 82, 69, 95, 69, 78, 68, 
	95, 37, 13, 32, 64, 9, 10, 9, 
	10, 13, 32, 64, 11, 12, 10, 32, 
	64, 9, 13, 32, 124, 9, 13, 10, 
	32, 92, 124, 9, 13, 10, 92, 124, 
	10, 92, 10, 32, 92, 124, 9, 13, 
	-48, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -48, -66, -48, -77, -48, 
	-80, -47, -126, -47, -128, -48, -75, -72, 
	-48, -76, -48, -72, -47, -127, -47, -126, 
	-48, -66, -47, -128, -48, -72, -47, -113, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -108, -104, -102, -99, 
	-96, -95, -94, -92, 10, -48, 10, -80, 
	10, -48, 10, -76, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -48, 10, -66, 
	10, 10, 32, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, -48, 10, 
	-66, 10, -48, 10, -77, 10, -48, 10, 
	-80, 10, -47, 10, -126, 10, -48, 10, 
	-80, 10, -48, 10, -68, 10, -48, 10, 
	-70, 10, -48, 10, -80, 10, 10, 32, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	10, 32, -47, 10, -127, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, 10, 58, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -68, -48, -75, 
	-47, -128, -48, -72, 58, 10, 10, -48, 
	10, 32, 35, 124, 9, 13, -92, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-48, 10, -72, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, -48, 10, -67, 10, 
	-48, 10, -66, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, 10, 58, -48, -80, 
	-48, -68, -48, -70, -48, -80, 32, -48, 
	-67, -48, -80, 32, -47, -127, -47, -122, 
	-48, -75, -48, -67, -48, -80, -47, -128, 
	-48, -72, -48, -71, 58, 10, 10, -48, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-108, -104, -102, -99, -95, -94, -92, 10, 
	-48, 10, -80, 10, -48, 10, -76, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -66, 10, 10, 32, -48, 10, 
	-66, 10, -48, 10, -77, 10, -48, 10, 
	-80, 10, -47, 10, -126, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, 10, 58, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -47, -122, -48, -75, 
	-48, -67, -48, -80, -47, -128, -48, -72, 
	-48, -71, 58, 10, 10, -48, 10, 32, 
	35, 37, 42, 64, 9, 13, -108, -104, 
	-102, -99, -97, -96, -95, -94, -92, 10, 
	-48, 10, -80, 10, -48, 10, -76, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -66, 10, 10, 32, -48, 10, 
	-66, 10, -48, 10, -77, 10, -48, 10, 
	-80, 10, -47, 10, -126, 10, -47, 10, 
	-128, 10, -48, 10, -75, 10, -48, 10, 
	-76, 10, -48, 10, -72, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-66, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -47, 10, -113, 10, 10, 58, 
	-48, 10, -80, 10, -48, 10, -68, 10, 
	-48, 10, -70, 10, -48, 10, -80, 10, 
	10, 32, -48, 10, -67, 10, -48, 10, 
	-80, 10, 10, 32, -47, 10, -127, 10, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -47, -125, -48, -67, 
	-48, -70, -47, -122, -48, -72, -48, -66, 
	-48, -67, -48, -80, -48, -69, -48, -67, 
	-48, -66, -47, -127, -47, -126, 58, 10, 
	10, -48, 10, 32, 35, 37, 64, 9, 
	13, -97, -96, -95, -92, 10, -47, 10, 
	-128, 10, -48, 10, -75, -72, 10, -48, 
	10, -76, 10, -48, 10, -72, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, 10, 
	58, -48, 10, -68, 10, -48, 10, -75, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -48, 10, -80, 10, -48, 10, -68, 
	10, -48, 10, -70, 10, -48, 10, -80, 
	10, 10, 32, -48, 10, -67, 10, -48, 
	10, -80, 10, 10, 32, -47, 10, -127, 
	10, -47, 10, -122, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -48, 10, -71, 10, -47, 10, -125, 
	10, -48, 10, -67, 10, -48, 10, -70, 
	10, -47, 10, -122, 10, -48, 10, -72, 
	10, -48, 10, -66, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -69, 
	10, -48, 10, -67, 10, -48, 10, -66, 
	10, -47, 10, -127, 10, -47, 10, -126, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 2, 
	9, 1, 1, 2, 2, 3, 3, 3, 
	3, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 3, 5, 3, 2, 4, 
	3, 2, 4, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 9, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	9, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 8, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 7, 10, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 6, 5, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 26, 28, 30, 
	32, 34, 36, 38, 40, 42, 44, 47, 
	50, 61, 63, 65, 68, 71, 76, 81, 
	86, 91, 95, 99, 102, 104, 106, 108, 
	110, 112, 114, 116, 118, 120, 122, 124, 
	126, 128, 130, 132, 137, 144, 149, 153, 
	159, 163, 166, 172, 183, 185, 187, 189, 
	191, 193, 195, 197, 199, 201, 203, 205, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 232, 234, 236, 238, 
	240, 242, 244, 246, 255, 265, 268, 271, 
	274, 277, 280, 283, 286, 289, 292, 295, 
	298, 309, 312, 315, 318, 321, 324, 327, 
	330, 333, 336, 339, 342, 345, 348, 351, 
	354, 357, 360, 363, 366, 369, 372, 375, 
	378, 381, 384, 387, 390, 393, 396, 399, 
	402, 405, 408, 411, 414, 417, 420, 423, 
	426, 429, 432, 435, 438, 441, 444, 447, 
	450, 453, 456, 459, 462, 465, 468, 471, 
	474, 477, 480, 483, 486, 489, 492, 495, 
	498, 501, 504, 507, 510, 513, 516, 519, 
	522, 525, 528, 531, 534, 537, 540, 543, 
	546, 548, 550, 552, 554, 556, 558, 560, 
	562, 564, 566, 568, 575, 578, 581, 584, 
	587, 590, 593, 596, 599, 602, 605, 608, 
	611, 614, 617, 620, 623, 626, 629, 632, 
	635, 638, 641, 644, 647, 650, 653, 656, 
	659, 661, 663, 665, 667, 669, 671, 673, 
	675, 677, 679, 681, 683, 685, 687, 689, 
	691, 693, 695, 697, 699, 701, 703, 705, 
	707, 709, 711, 713, 715, 717, 719, 721, 
	723, 725, 734, 743, 746, 749, 752, 755, 
	758, 761, 764, 767, 770, 773, 776, 779, 
	782, 785, 788, 791, 794, 797, 800, 803, 
	806, 809, 812, 815, 818, 821, 824, 827, 
	830, 833, 836, 839, 842, 845, 848, 851, 
	854, 857, 860, 863, 866, 869, 872, 875, 
	878, 881, 884, 887, 890, 893, 896, 899, 
	902, 905, 908, 911, 914, 917, 920, 923, 
	926, 929, 932, 935, 938, 941, 944, 947, 
	950, 953, 956, 959, 962, 965, 967, 969, 
	971, 973, 975, 977, 979, 981, 983, 985, 
	987, 989, 991, 993, 995, 997, 999, 1008, 
	1019, 1022, 1025, 1028, 1031, 1034, 1037, 1040, 
	1043, 1046, 1049, 1052, 1055, 1058, 1061, 1064, 
	1067, 1070, 1073, 1076, 1079, 1082, 1085, 1088, 
	1091, 1094, 1097, 1100, 1103, 1106, 1109, 1112, 
	1115, 1118, 1121, 1124, 1127, 1130, 1133, 1136, 
	1139, 1142, 1145, 1148, 1151, 1154, 1157, 1160, 
	1163, 1166, 1169, 1172, 1175, 1178, 1181, 1184, 
	1187, 1190, 1193, 1196, 1199, 1202, 1205, 1208, 
	1211, 1214, 1217, 1220, 1223, 1226, 1229, 1232, 
	1235, 1238, 1241, 1244, 1247, 1250, 1253, 1256, 
	1259, 1262, 1265, 1268, 1271, 1274, 1277, 1280, 
	1283, 1286, 1289, 1292, 1295, 1298, 1301, 1304, 
	1307, 1310, 1313, 1316, 1319, 1322, 1325, 1328, 
	1331, 1334, 1337, 1340, 1343, 1346, 1349, 1351, 
	1353, 1355, 1357, 1359, 1361, 1363, 1365, 1367, 
	1369, 1371, 1373, 1375, 1377, 1379, 1381, 1383, 
	1385, 1387, 1389, 1391, 1393, 1395, 1397, 1399, 
	1401, 1403, 1405, 1407, 1415, 1421, 1424, 1427, 
	1430, 1434, 1437, 1440, 1443, 1446, 1449, 1452, 
	1455, 1458, 1461, 1464, 1467, 1470, 1473, 1476, 
	1479, 1482, 1485, 1488, 1491, 1494, 1497, 1500, 
	1503, 1506, 1509, 1512, 1515, 1518, 1521, 1524, 
	1527, 1530, 1533, 1536, 1539, 1542, 1545, 1548, 
	1551, 1554, 1557, 1560, 1563, 1566, 1569, 1572, 
	1575, 1578, 1581, 1584, 1587, 1590, 1593, 1596, 
	1599, 1602, 1605, 1608, 1611, 1614, 1617, 1620, 
	1623, 1626, 1629, 1632, 1635, 1638, 1641, 1644, 
	1647, 1650, 1653, 1656, 1659, 1662, 1665, 1668, 
	1671, 1674, 1677, 1680, 1683, 1686, 1689, 1692, 
	1695, 1698, 1701, 1704, 1707, 1710, 1713, 1716, 
	1719, 1721, 1723
};

static const short _lexer_trans_targs[] = {
	2, 584, 16, 16, 17, 27, 29, 13, 
	43, 46, 16, 0, 3, 13, 52, 11, 
	60, 216, 325, 11, 454, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 11, 0, 12, 0, 
	13, 0, 14, 0, 16, 28, 15, 16, 
	28, 15, 2, 16, 16, 17, 27, 29, 
	13, 43, 46, 16, 0, 18, 0, 19, 
	0, 21, 20, 20, 21, 20, 20, 22, 
	22, 23, 22, 22, 22, 22, 23, 22, 
	22, 22, 22, 24, 22, 22, 22, 22, 
	25, 22, 22, 16, 26, 26, 0, 16, 
	26, 26, 0, 16, 28, 27, 16, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 37, 0, 
	38, 0, 39, 0, 40, 0, 41, 0, 
	42, 0, 586, 0, 0, 0, 0, 0, 
	44, 45, 16, 45, 45, 43, 44, 44, 
	16, 45, 43, 45, 0, 46, 47, 46, 
	0, 51, 50, 49, 47, 50, 48, 0, 
	49, 47, 48, 0, 49, 48, 51, 50, 
	49, 47, 50, 48, 2, 51, 51, 17, 
	27, 29, 13, 43, 46, 51, 0, 53, 
	0, 54, 0, 55, 0, 56, 0, 57, 
	0, 58, 0, 59, 0, 11, 0, 61, 
	0, 62, 0, 63, 0, 64, 176, 0, 
	65, 0, 66, 0, 67, 0, 68, 0, 
	69, 0, 70, 0, 71, 0, 72, 0, 
	73, 0, 74, 0, 75, 0, 76, 0, 
	77, 0, 78, 0, 79, 0, 80, 0, 
	81, 0, 83, 82, 83, 82, 84, 83, 
	83, 16, 162, 95, 16, 83, 82, 85, 
	95, 97, 93, 105, 121, 93, 136, 83, 
	82, 86, 83, 82, 87, 83, 82, 88, 
	83, 82, 89, 83, 82, 90, 83, 82, 
	91, 83, 82, 92, 83, 82, 93, 83, 
	82, 94, 83, 82, 95, 83, 82, 83, 
	96, 82, 2, 16, 16, 17, 27, 29, 
	13, 43, 46, 16, 0, 98, 83, 82, 
	99, 83, 82, 100, 83, 82, 101, 83, 
	82, 102, 83, 82, 103, 83, 82, 104, 
	83, 82, 93, 83, 82, 106, 83, 82, 
	107, 83, 82, 108, 83, 82, 109, 83, 
	82, 110, 83, 82, 111, 83, 82, 112, 
	83, 82, 113, 83, 82, 83, 114, 82, 
	115, 83, 82, 116, 83, 82, 117, 83, 
	82, 118, 83, 82, 83, 119, 82, 120, 
	83, 82, 121, 83, 82, 122, 83, 82, 
	123, 83, 82, 124, 83, 82, 125, 83, 
	82, 126, 83, 82, 127, 83, 82, 128, 
	83, 82, 129, 83, 82, 130, 83, 82, 
	131, 83, 82, 132, 83, 82, 133, 83, 
	82, 134, 83, 82, 135, 83, 82, 83, 
	96, 82, 137, 83, 82, 138, 83, 82, 
	139, 83, 82, 140, 83, 82, 141, 83, 
	82, 142, 83, 82, 143, 83, 82, 144, 
	83, 82, 145, 83, 82, 146, 83, 82, 
	147, 83, 82, 148, 83, 82, 149, 83, 
	82, 150, 83, 82, 151, 83, 82, 152, 
	83, 82, 153, 83, 82, 154, 83, 82, 
	155, 83, 82, 156, 83, 82, 157, 83, 
	82, 158, 83, 82, 159, 83, 82, 160, 
	83, 82, 161, 83, 82, 135, 83, 82, 
	83, 163, 82, 83, 164, 82, 83, 165, 
	82, 83, 166, 82, 83, 167, 82, 83, 
	168, 82, 83, 169, 82, 83, 170, 82, 
	83, 171, 82, 83, 172, 82, 83, 173, 
	82, 83, 174, 82, 83, 175, 82, 83, 
	16, 82, 177, 0, 178, 0, 179, 0, 
	180, 0, 181, 0, 182, 0, 183, 0, 
	184, 0, 185, 0, 187, 186, 187, 186, 
	188, 187, 187, 16, 16, 187, 186, 189, 
	187, 186, 190, 187, 186, 191, 187, 186, 
	192, 187, 186, 193, 187, 186, 194, 187, 
	186, 195, 187, 186, 196, 187, 186, 197, 
	187, 186, 198, 187, 186, 199, 187, 186, 
	200, 187, 186, 201, 187, 186, 202, 187, 
	186, 203, 187, 186, 204, 187, 186, 205, 
	187, 186, 206, 187, 186, 207, 187, 186, 
	208, 187, 186, 209, 187, 186, 210, 187, 
	186, 211, 187, 186, 212, 187, 186, 213, 
	187, 186, 214, 187, 186, 215, 187, 186, 
	187, 96, 186, 217, 0, 218, 0, 219, 
	0, 220, 0, 221, 0, 222, 0, 223, 
	0, 224, 0, 225, 0, 226, 0, 227, 
	0, 228, 0, 229, 0, 230, 0, 231, 
	0, 232, 0, 233, 0, 234, 0, 235, 
	0, 236, 0, 237, 0, 238, 0, 239, 
	0, 240, 0, 241, 0, 242, 0, 243, 
	0, 244, 0, 245, 0, 246, 0, 247, 
	0, 249, 248, 249, 248, 250, 249, 249, 
	16, 311, 261, 16, 249, 248, 251, 261, 
	262, 259, 270, 259, 285, 249, 248, 252, 
	249, 248, 253, 249, 248, 254, 249, 248, 
	255, 249, 248, 256, 249, 248, 257, 249, 
	248, 258, 249, 248, 259, 249, 248, 260, 
	249, 248, 261, 249, 248, 249, 96, 248, 
	263, 249, 248, 264, 249, 248, 265, 249, 
	248, 266, 249, 248, 267, 249, 248, 268, 
	249, 248, 269, 249, 248, 259, 249, 248, 
	271, 249, 248, 272, 249, 248, 273, 249, 
	248, 274, 249, 248, 275, 249, 248, 276, 
	249, 248, 277, 249, 248, 278, 249, 248, 
	279, 249, 248, 280, 249, 248, 281, 249, 
	248, 282, 249, 248, 283, 249, 248, 284, 
	249, 248, 249, 96, 248, 286, 249, 248, 
	287, 249, 248, 288, 249, 248, 289, 249, 
	248, 290, 249, 248, 291, 249, 248, 292, 
	249, 248, 293, 249, 248, 294, 249, 248, 
	295, 249, 248, 296, 249, 248, 297, 249, 
	248, 298, 249, 248, 299, 249, 248, 300, 
	249, 248, 301, 249, 248, 302, 249, 248, 
	303, 249, 248, 304, 249, 248, 305, 249, 
	248, 306, 249, 248, 307, 249, 248, 308, 
	249, 248, 309, 249, 248, 310, 249, 248, 
	284, 249, 248, 249, 312, 248, 249, 313, 
	248, 249, 314, 248, 249, 315, 248, 249, 
	316, 248, 249, 317, 248, 249, 318, 248, 
	249, 319, 248, 249, 320, 248, 249, 321, 
	248, 249, 322, 248, 249, 323, 248, 249, 
	324, 248, 249, 16, 248, 326, 0, 327, 
	0, 328, 0, 329, 0, 330, 0, 331, 
	0, 332, 0, 333, 0, 334, 0, 335, 
	0, 336, 0, 337, 0, 338, 0, 339, 
	0, 340, 0, 342, 341, 342, 341, 343, 
	342, 342, 16, 440, 354, 16, 342, 341, 
	344, 354, 355, 352, 363, 384, 400, 352, 
	414, 342, 341, 345, 342, 341, 346, 342, 
	341, 347, 342, 341, 348, 342, 341, 349, 
	342, 341, 350, 342, 341, 351, 342, 341, 
	352, 342, 341, 353, 342, 341, 354, 342, 
	341, 342, 96, 341, 356, 342, 341, 357, 
	342, 341, 358, 342, 341, 359, 342, 341, 
	360, 342, 341, 361, 342, 341, 362, 342, 
	341, 352, 342, 341, 364, 342, 341, 365, 
	342, 341, 366, 342, 341, 367, 342, 341, 
	368, 342, 341, 369, 342, 341, 370, 342, 
	341, 371, 342, 341, 372, 342, 341, 373, 
	342, 341, 374, 342, 341, 375, 342, 341, 
	376, 342, 341, 377, 342, 341, 378, 342, 
	341, 379, 342, 341, 380, 342, 341, 381, 
	342, 341, 382, 342, 341, 383, 342, 341, 
	342, 96, 341, 385, 342, 341, 386, 342, 
	341, 387, 342, 341, 388, 342, 341, 389, 
	342, 341, 390, 342, 341, 391, 342, 341, 
	392, 342, 341, 342, 393, 341, 394, 342, 
	341, 395, 342, 341, 396, 342, 341, 397, 
	342, 341, 342, 398, 341, 399, 342, 341, 
	400, 342, 341, 401, 342, 341, 402, 342, 
	341, 403, 342, 341, 404, 342, 341, 405, 
	342, 341, 406, 342, 341, 407, 342, 341, 
	408, 342, 341, 409, 342, 341, 410, 342, 
	341, 411, 342, 341, 412, 342, 341, 413, 
	342, 341, 383, 342, 341, 415, 342, 341, 
	416, 342, 341, 417, 342, 341, 418, 342, 
	341, 419, 342, 341, 420, 342, 341, 421, 
	342, 341, 422, 342, 341, 423, 342, 341, 
	424, 342, 341, 425, 342, 341, 426, 342, 
	341, 427, 342, 341, 428, 342, 341, 429, 
	342, 341, 430, 342, 341, 431, 342, 341, 
	432, 342, 341, 433, 342, 341, 434, 342, 
	341, 435, 342, 341, 436, 342, 341, 437, 
	342, 341, 438, 342, 341, 439, 342, 341, 
	383, 342, 341, 342, 441, 341, 342, 442, 
	341, 342, 443, 341, 342, 444, 341, 342, 
	445, 341, 342, 446, 341, 342, 447, 341, 
	342, 448, 341, 342, 449, 341, 342, 450, 
	341, 342, 451, 341, 342, 452, 341, 342, 
	453, 341, 342, 16, 341, 455, 0, 456, 
	0, 457, 0, 458, 0, 459, 0, 460, 
	0, 461, 0, 462, 0, 463, 0, 464, 
	0, 465, 0, 466, 0, 467, 0, 468, 
	0, 469, 0, 470, 0, 471, 0, 472, 
	0, 473, 0, 474, 0, 475, 0, 476, 
	0, 477, 0, 478, 0, 479, 0, 480, 
	0, 481, 0, 483, 482, 483, 482, 484, 
	483, 483, 16, 570, 16, 483, 482, 485, 
	514, 530, 544, 483, 482, 486, 483, 482, 
	487, 483, 482, 488, 483, 482, 489, 506, 
	483, 482, 490, 483, 482, 491, 483, 482, 
	492, 483, 482, 493, 483, 482, 494, 483, 
	482, 495, 483, 482, 496, 483, 482, 497, 
	483, 482, 498, 483, 482, 499, 483, 482, 
	500, 483, 482, 501, 483, 482, 502, 483, 
	482, 503, 483, 482, 504, 483, 482, 505, 
	483, 482, 483, 96, 482, 507, 483, 482, 
	508, 483, 482, 509, 483, 482, 510, 483, 
	482, 511, 483, 482, 512, 483, 482, 513, 
	483, 482, 505, 483, 482, 515, 483, 482, 
	516, 483, 482, 517, 483, 482, 518, 483, 
	482, 519, 483, 482, 520, 483, 482, 521, 
	483, 482, 522, 483, 482, 483, 523, 482, 
	524, 483, 482, 525, 483, 482, 526, 483, 
	482, 527, 483, 482, 483, 528, 482, 529, 
	483, 482, 530, 483, 482, 531, 483, 482, 
	532, 483, 482, 533, 483, 482, 534, 483, 
	482, 535, 483, 482, 536, 483, 482, 537, 
	483, 482, 538, 483, 482, 539, 483, 482, 
	540, 483, 482, 541, 483, 482, 542, 483, 
	482, 543, 483, 482, 505, 483, 482, 545, 
	483, 482, 546, 483, 482, 547, 483, 482, 
	548, 483, 482, 549, 483, 482, 550, 483, 
	482, 551, 483, 482, 552, 483, 482, 553, 
	483, 482, 554, 483, 482, 555, 483, 482, 
	556, 483, 482, 557, 483, 482, 558, 483, 
	482, 559, 483, 482, 560, 483, 482, 561, 
	483, 482, 562, 483, 482, 563, 483, 482, 
	564, 483, 482, 565, 483, 482, 566, 483, 
	482, 567, 483, 482, 568, 483, 482, 569, 
	483, 482, 505, 483, 482, 483, 571, 482, 
	483, 572, 482, 483, 573, 482, 483, 574, 
	482, 483, 575, 482, 483, 576, 482, 483, 
	577, 482, 483, 578, 482, 483, 579, 482, 
	483, 580, 482, 483, 581, 482, 483, 582, 
	482, 483, 583, 482, 483, 16, 482, 585, 
	0, 16, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 29, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 0, 0, 
	43, 54, 37, 37, 87, 37, 37, 43, 
	0, 39, 0, 43, 0, 0, 54, 0, 
	0, 39, 0, 0, 96, 54, 0, 93, 
	90, 41, 96, 90, 99, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 72, 33, 84, 72, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	15, 0, 63, 130, 31, 60, 57, 31, 
	63, 57, 66, 31, 43, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	15, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	15, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 54, 0, 81, 81, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 21, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 19, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 19, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 75, 33, 84, 75, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 69, 33, 69, 0, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 13, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 0, 
	43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 586;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1259 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
    
#line 1266 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1556 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1619 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/bg.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_bg()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Bg", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

