
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 20, 21, 22, 41, 42, 43, 
	47, 52, 57, 62, 67, 71, 75, 77, 
	78, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 92, 93, 
	94, 96, 101, 108, 113, 114, 115, 116, 
	117, 119, 120, 121, 122, 123, 124, 125, 
	126, 127, 128, 129, 130, 131, 132, 133, 
	134, 135, 136, 137, 138, 139, 140, 141, 
	142, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 171, 173, 175, 177, 
	196, 198, 199, 200, 201, 202, 203, 204, 
	205, 206, 207, 208, 209, 225, 227, 229, 
	231, 233, 235, 237, 239, 241, 243, 245, 
	247, 249, 251, 253, 255, 257, 259, 261, 
	263, 266, 268, 270, 272, 274, 276, 278, 
	280, 282, 284, 286, 288, 291, 293, 295, 
	297, 299, 301, 303, 305, 307, 309, 311, 
	313, 315, 317, 319, 321, 323, 325, 327, 
	329, 331, 333, 335, 337, 339, 341, 343, 
	346, 348, 350, 352, 354, 356, 358, 360, 
	362, 364, 366, 368, 370, 372, 374, 376, 
	378, 381, 383, 385, 387, 389, 391, 393, 
	395, 397, 399, 401, 403, 404, 405, 406, 
	407, 408, 409, 410, 411, 412, 413, 414, 
	415, 416, 417, 418, 419, 420, 421, 422, 
	423, 439, 441, 443, 445, 447, 449, 451, 
	453, 455, 457, 459, 461, 463, 465, 467, 
	469, 471, 473, 475, 477, 480, 482, 484, 
	486, 488, 490, 492, 494, 496, 498, 500, 
	502, 504, 506, 508, 510, 512, 514, 516, 
	518, 520, 522, 525, 527, 529, 531, 533, 
	535, 537, 539, 541, 543, 545, 547, 549, 
	551, 553, 555, 557, 559, 561, 563, 565, 
	567, 569, 570, 571, 572, 573, 574, 575, 
	576, 577, 578, 579, 580, 581, 582, 583, 
	584, 595, 597, 599, 601, 603, 605, 607, 
	609, 611, 613, 615, 617, 619, 621, 623, 
	625, 627, 629, 631, 633, 635, 637, 639, 
	641, 643, 646, 648, 650, 652, 654, 656, 
	658, 660, 662, 664, 666, 668, 670, 672, 
	674, 676, 678, 680, 682, 684, 686, 688, 
	690, 692, 694, 696, 698, 700, 702, 704, 
	706, 708, 710, 712, 714, 716, 718, 720, 
	722, 724, 726, 728, 730, 732, 734, 736, 
	738, 740, 741, 742, 743, 744, 746, 747, 
	748, 749, 750, 751, 752, 753, 754, 755, 
	756, 757, 773, 775, 777, 779, 781, 783, 
	785, 787, 789, 791, 793, 795, 797, 799, 
	801, 803, 805, 807, 809, 811, 814, 816, 
	818, 820, 822, 824, 826, 828, 830, 832, 
	834, 836, 839, 841, 843, 845, 847, 849, 
	851, 853, 855, 857, 859, 861, 863, 865, 
	867, 869, 871, 873, 875, 877, 879, 881, 
	883, 885, 887, 889, 891, 894, 896, 898, 
	900, 902, 904, 906, 908, 910, 912, 914, 
	916, 918, 920, 922, 924, 926, 928, 930, 
	932, 934, 936, 937, 938, 939, 940, 944, 
	950, 953, 955, 961, 980
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 73, 74, 77, 79, 80, 83, 87, 
	90, 124, 9, 13, -69, -65, 10, 32, 
	34, 35, 37, 42, 64, 65, 73, 74, 
	77, 79, 80, 83, 87, 90, 124, 9, 
	13, 34, 34, 10, 32, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 10, 10, 13, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 108, 101, 101, -59, -101, -68, 108, 
	105, 101, 97, 106, -60, -123, 99, 114, 
	97, 122, 114, 122, 121, 107, -59, -126, 
	97, 100, 121, 58, 10, 10, 10, 32, 
	35, 87, 124, 9, 13, -59, 10, -126, 
	10, 10, 97, -59, 10, -101, 10, 10, 
	99, 10, 105, 10, 119, 10, 111, -59, 
	10, -101, 10, -60, 10, -121, 10, 10, 
	58, 10, 32, 34, 35, 37, 42, 64, 
	65, 73, 74, 77, 79, 80, 83, 87, 
	90, 124, 9, 13, 99, 122, 101, 110, 
	97, 114, 105, 117, 115, 122, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	73, 74, 77, 79, 83, 87, 90, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	108, 10, 101, 10, 101, -59, 10, -101, 
	-68, 10, 10, 108, 10, 105, 10, 101, 
	10, 97, 10, 106, -60, 10, -123, 10, 
	10, 99, 10, 114, 10, 97, 10, 122, 
	10, 99, 122, 10, 101, 10, 110, 10, 
	97, 10, 114, 10, 105, 10, 117, 10, 
	115, 10, 122, 10, 58, 10, 97, 10, 
	98, 10, 108, 10, 111, 10, 110, 10, 
	32, 10, 115, 10, 99, 10, 101, 10, 
	110, 10, 97, 10, 114, 10, 105, 10, 
	117, 10, 115, 10, 122, 10, 97, -59, 
	10, 116, -126, 10, 10, 97, -59, 10, 
	-101, 10, 10, 99, 10, 105, 10, 119, 
	10, 111, -59, 10, -101, 10, -60, 10, 
	-121, 10, 10, 101, 10, 100, 10, 121, 
	10, 97, -59, 10, 107, -126, 10, 10, 
	111, -59, 10, -68, 10, 10, 101, 10, 
	110, 10, 105, -59, 10, -126, 10, 10, 
	97, 10, 100, 97, 98, 108, 111, 110, 
	32, 115, 99, 101, 110, 97, 114, 105, 
	117, 115, 122, 97, 58, 10, 10, 10, 
	32, 35, 37, 42, 64, 65, 73, 74, 
	77, 79, 83, 87, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 108, 10, 
	101, 10, 101, -59, 10, -101, -68, 10, 
	10, 108, 10, 105, 10, 101, 10, 97, 
	10, 106, -60, 10, -123, 10, 10, 99, 
	10, 114, 10, 97, 10, 122, 10, 99, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 117, 10, 115, 10, 122, 
	10, 58, -59, 10, 116, -126, 10, 10, 
	97, -59, 10, -101, 10, 10, 99, 10, 
	105, 10, 119, 10, 111, -59, 10, -101, 
	10, -60, 10, -121, 10, 10, 101, 10, 
	100, 10, 121, 10, 97, 10, 107, -59, 
	10, -126, 10, 10, 97, 10, 100, -59, 
	116, -126, 97, -59, -101, 99, 105, 119, 
	111, -59, -101, -60, -121, 58, 10, 10, 
	10, 32, 35, 37, 64, 80, 83, 87, 
	90, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	114, 10, 122, 10, 121, 10, 107, -59, 
	10, -126, 10, 10, 97, 10, 100, 10, 
	121, 10, 58, 10, 99, 122, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 115, 10, 122, 10, 97, 
	10, 98, 10, 108, 10, 111, 10, 110, 
	10, 32, 10, 115, 10, 99, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 115, 10, 122, 10, 97, 
	-59, 10, -126, 10, 10, 97, -59, 10, 
	-101, 10, 10, 99, 10, 105, 10, 119, 
	10, 111, -59, 10, -101, 10, -60, 10, 
	-121, 10, 10, 97, -59, 10, -126, 10, 
	10, 111, -59, 10, -68, 10, 10, 101, 
	10, 110, 10, 105, 101, 100, 121, 97, 
	-59, 107, -126, 111, -59, -68, 101, 110, 
	105, 97, 58, 10, 10, 10, 32, 35, 
	37, 42, 64, 65, 73, 74, 77, 79, 
	83, 87, 90, 9, 13, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, 10, 32, 10, 108, 10, 101, 10, 
	101, -59, 10, -101, -68, 10, 10, 108, 
	10, 105, 10, 101, 10, 97, 10, 106, 
	-60, 10, -123, 10, 10, 99, 10, 114, 
	10, 97, 10, 122, 10, 99, 122, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 117, 10, 115, 10, 122, 10, 
	58, 10, 97, 10, 98, 10, 108, 10, 
	111, 10, 110, 10, 32, 10, 115, 10, 
	99, 10, 101, 10, 110, 10, 97, 10, 
	114, 10, 105, 10, 117, 10, 115, 10, 
	122, 10, 97, -59, 10, 116, -126, 10, 
	10, 97, -59, 10, -101, 10, 10, 99, 
	10, 105, 10, 119, 10, 111, -59, 10, 
	-101, 10, -60, 10, -121, 10, 10, 101, 
	10, 100, 10, 121, 10, 97, 10, 107, 
	-59, 10, -126, 10, 10, 97, 10, 100, 
	-59, -126, 97, 100, 32, 124, 9, 13, 
	10, 32, 92, 124, 9, 13, 10, 92, 
	124, 10, 92, 10, 32, 92, 124, 9, 
	13, 10, 32, 34, 35, 37, 42, 64, 
	65, 73, 74, 77, 79, 80, 83, 87, 
	90, 124, 9, 13, 0
};

static const char _lexer_single_lengths[] = {
	0, 18, 1, 1, 17, 1, 1, 2, 
	3, 3, 3, 3, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 3, 5, 3, 1, 1, 1, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	5, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 17, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 14, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	14, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	9, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 14, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 2, 4, 
	3, 2, 4, 17, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	0, 0, 1, 1, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 20, 22, 24, 43, 45, 47, 
	51, 56, 61, 66, 71, 75, 79, 82, 
	84, 86, 88, 90, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 119, 124, 131, 136, 138, 140, 142, 
	144, 147, 149, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 200, 203, 206, 209, 212, 215, 218, 
	221, 224, 227, 230, 233, 236, 239, 242, 
	261, 264, 266, 268, 270, 272, 274, 276, 
	278, 280, 282, 284, 286, 302, 305, 308, 
	311, 314, 317, 320, 323, 326, 329, 332, 
	335, 338, 341, 344, 347, 350, 353, 356, 
	359, 363, 366, 369, 372, 375, 378, 381, 
	384, 387, 390, 393, 396, 400, 403, 406, 
	409, 412, 415, 418, 421, 424, 427, 430, 
	433, 436, 439, 442, 445, 448, 451, 454, 
	457, 460, 463, 466, 469, 472, 475, 478, 
	482, 485, 488, 491, 494, 497, 500, 503, 
	506, 509, 512, 515, 518, 521, 524, 527, 
	530, 534, 537, 540, 543, 546, 549, 552, 
	555, 558, 561, 564, 567, 569, 571, 573, 
	575, 577, 579, 581, 583, 585, 587, 589, 
	591, 593, 595, 597, 599, 601, 603, 605, 
	607, 623, 626, 629, 632, 635, 638, 641, 
	644, 647, 650, 653, 656, 659, 662, 665, 
	668, 671, 674, 677, 680, 684, 687, 690, 
	693, 696, 699, 702, 705, 708, 711, 714, 
	717, 720, 723, 726, 729, 732, 735, 738, 
	741, 744, 747, 751, 754, 757, 760, 763, 
	766, 769, 772, 775, 778, 781, 784, 787, 
	790, 793, 796, 799, 802, 805, 808, 811, 
	814, 817, 819, 821, 823, 825, 827, 829, 
	831, 833, 835, 837, 839, 841, 843, 845, 
	847, 858, 861, 864, 867, 870, 873, 876, 
	879, 882, 885, 888, 891, 894, 897, 900, 
	903, 906, 909, 912, 915, 918, 921, 924, 
	927, 930, 934, 937, 940, 943, 946, 949, 
	952, 955, 958, 961, 964, 967, 970, 973, 
	976, 979, 982, 985, 988, 991, 994, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1030, 1033, 1036, 1039, 1042, 1045, 
	1048, 1051, 1054, 1057, 1060, 1063, 1066, 1069, 
	1072, 1075, 1077, 1079, 1081, 1083, 1086, 1088, 
	1090, 1092, 1094, 1096, 1098, 1100, 1102, 1104, 
	1106, 1108, 1124, 1127, 1130, 1133, 1136, 1139, 
	1142, 1145, 1148, 1151, 1154, 1157, 1160, 1163, 
	1166, 1169, 1172, 1175, 1178, 1181, 1185, 1188, 
	1191, 1194, 1197, 1200, 1203, 1206, 1209, 1212, 
	1215, 1218, 1222, 1225, 1228, 1231, 1234, 1237, 
	1240, 1243, 1246, 1249, 1252, 1255, 1258, 1261, 
	1264, 1267, 1270, 1273, 1276, 1279, 1282, 1285, 
	1288, 1291, 1294, 1297, 1300, 1304, 1307, 1310, 
	1313, 1316, 1319, 1322, 1325, 1328, 1331, 1334, 
	1337, 1340, 1343, 1346, 1349, 1352, 1355, 1358, 
	1361, 1364, 1367, 1369, 1371, 1373, 1375, 1379, 
	1385, 1389, 1392, 1398, 1417
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 14, 16, 30, 33, 
	36, 30, 38, 44, 49, 52, 80, 264, 
	356, 454, 4, 0, 3, 0, 4, 0, 
	4, 4, 5, 14, 16, 30, 33, 36, 
	30, 38, 44, 49, 52, 80, 264, 356, 
	454, 4, 0, 6, 0, 7, 0, 8, 
	7, 7, 0, 9, 9, 10, 9, 9, 
	9, 9, 10, 9, 9, 9, 9, 11, 
	9, 9, 9, 9, 12, 9, 9, 4, 
	13, 13, 0, 4, 13, 13, 0, 4, 
	15, 14, 4, 0, 17, 0, 18, 0, 
	19, 0, 20, 0, 21, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 460, 0, 
	31, 0, 0, 32, 4, 15, 32, 0, 
	0, 0, 0, 34, 35, 4, 35, 35, 
	33, 34, 34, 4, 35, 33, 35, 0, 
	37, 0, 30, 0, 39, 0, 40, 0, 
	41, 43, 0, 42, 0, 30, 0, 41, 
	0, 45, 0, 46, 0, 47, 0, 48, 
	0, 30, 0, 50, 0, 51, 0, 30, 
	0, 53, 0, 54, 0, 55, 0, 56, 
	0, 57, 0, 58, 0, 59, 0, 60, 
	0, 61, 0, 62, 0, 64, 63, 64, 
	63, 64, 64, 4, 65, 4, 64, 63, 
	66, 64, 63, 67, 64, 63, 64, 68, 
	63, 69, 64, 63, 70, 64, 63, 64, 
	71, 63, 64, 72, 63, 64, 73, 63, 
	64, 74, 63, 75, 64, 63, 76, 64, 
	63, 77, 64, 63, 78, 64, 63, 64, 
	79, 63, 4, 4, 5, 14, 16, 30, 
	33, 36, 30, 38, 44, 49, 52, 80, 
	264, 356, 454, 4, 0, 81, 180, 0, 
	82, 0, 83, 0, 84, 0, 85, 0, 
	86, 0, 87, 0, 88, 0, 89, 0, 
	90, 0, 92, 91, 92, 91, 92, 92, 
	4, 93, 107, 4, 108, 107, 110, 116, 
	121, 124, 151, 167, 92, 91, 92, 94, 
	91, 92, 95, 91, 92, 96, 91, 92, 
	97, 91, 92, 98, 91, 92, 99, 91, 
	92, 100, 91, 92, 101, 91, 92, 102, 
	91, 92, 103, 91, 92, 104, 91, 92, 
	105, 91, 92, 106, 91, 92, 4, 91, 
	92, 79, 91, 92, 109, 91, 92, 107, 
	91, 92, 111, 91, 112, 92, 91, 113, 
	115, 92, 91, 92, 114, 91, 92, 107, 
	91, 92, 113, 91, 92, 117, 91, 92, 
	118, 91, 119, 92, 91, 120, 92, 91, 
	92, 107, 91, 92, 122, 91, 92, 123, 
	91, 92, 107, 91, 92, 125, 134, 91, 
	92, 126, 91, 92, 127, 91, 92, 128, 
	91, 92, 129, 91, 92, 130, 91, 92, 
	131, 91, 92, 132, 91, 92, 133, 91, 
	92, 79, 91, 92, 135, 91, 92, 136, 
	91, 92, 137, 91, 92, 138, 91, 92, 
	139, 91, 92, 140, 91, 92, 141, 91, 
	92, 142, 91, 92, 143, 91, 92, 144, 
	91, 92, 145, 91, 92, 146, 91, 92, 
	147, 91, 92, 148, 91, 92, 149, 91, 
	92, 150, 91, 92, 133, 91, 152, 92, 
	164, 91, 153, 92, 91, 92, 154, 91, 
	155, 92, 91, 156, 92, 91, 92, 157, 
	91, 92, 158, 91, 92, 159, 91, 92, 
	160, 91, 161, 92, 91, 162, 92, 91, 
	163, 92, 91, 133, 92, 91, 92, 165, 
	91, 92, 166, 91, 92, 107, 91, 92, 
	168, 91, 169, 92, 176, 91, 170, 92, 
	91, 92, 171, 91, 172, 92, 91, 173, 
	92, 91, 92, 174, 91, 92, 175, 91, 
	92, 150, 91, 177, 92, 91, 178, 92, 
	91, 92, 179, 91, 92, 116, 91, 181, 
	0, 182, 0, 183, 0, 184, 0, 185, 
	0, 186, 0, 187, 0, 188, 0, 189, 
	0, 190, 0, 191, 0, 192, 0, 193, 
	0, 194, 0, 195, 0, 196, 0, 197, 
	0, 198, 0, 200, 199, 200, 199, 200, 
	200, 4, 201, 215, 4, 216, 215, 218, 
	224, 229, 232, 242, 258, 200, 199, 200, 
	202, 199, 200, 203, 199, 200, 204, 199, 
	200, 205, 199, 200, 206, 199, 200, 207, 
	199, 200, 208, 199, 200, 209, 199, 200, 
	210, 199, 200, 211, 199, 200, 212, 199, 
	200, 213, 199, 200, 214, 199, 200, 4, 
	199, 200, 79, 199, 200, 217, 199, 200, 
	215, 199, 200, 219, 199, 220, 200, 199, 
	221, 223, 200, 199, 200, 222, 199, 200, 
	215, 199, 200, 221, 199, 200, 225, 199, 
	200, 226, 199, 227, 200, 199, 228, 200, 
	199, 200, 215, 199, 200, 230, 199, 200, 
	231, 199, 200, 215, 199, 200, 233, 199, 
	200, 234, 199, 200, 235, 199, 200, 236, 
	199, 200, 237, 199, 200, 238, 199, 200, 
	239, 199, 200, 240, 199, 200, 241, 199, 
	200, 79, 199, 243, 200, 255, 199, 244, 
	200, 199, 200, 245, 199, 246, 200, 199, 
	247, 200, 199, 200, 248, 199, 200, 249, 
	199, 200, 250, 199, 200, 251, 199, 252, 
	200, 199, 253, 200, 199, 254, 200, 199, 
	241, 200, 199, 200, 256, 199, 200, 257, 
	199, 200, 215, 199, 200, 259, 199, 200, 
	260, 199, 261, 200, 199, 262, 200, 199, 
	200, 263, 199, 200, 224, 199, 265, 353, 
	0, 266, 0, 267, 0, 268, 0, 269, 
	0, 270, 0, 271, 0, 272, 0, 273, 
	0, 274, 0, 275, 0, 276, 0, 277, 
	0, 278, 0, 280, 279, 280, 279, 280, 
	280, 4, 281, 4, 295, 305, 331, 344, 
	280, 279, 280, 282, 279, 280, 283, 279, 
	280, 284, 279, 280, 285, 279, 280, 286, 
	279, 280, 287, 279, 280, 288, 279, 280, 
	289, 279, 280, 290, 279, 280, 291, 279, 
	280, 292, 279, 280, 293, 279, 280, 294, 
	279, 280, 4, 279, 280, 296, 279, 280, 
	297, 279, 280, 298, 279, 280, 299, 279, 
	300, 280, 279, 301, 280, 279, 280, 302, 
	279, 280, 303, 279, 280, 304, 279, 280, 
	79, 279, 280, 306, 314, 279, 280, 307, 
	279, 280, 308, 279, 280, 309, 279, 280, 
	310, 279, 280, 311, 279, 280, 312, 279, 
	280, 313, 279, 280, 304, 279, 280, 315, 
	279, 280, 316, 279, 280, 317, 279, 280, 
	318, 279, 280, 319, 279, 280, 320, 279, 
	280, 321, 279, 280, 322, 279, 280, 323, 
	279, 280, 324, 279, 280, 325, 279, 280, 
	326, 279, 280, 327, 279, 280, 328, 279, 
	280, 329, 279, 280, 330, 279, 280, 304, 
	279, 332, 280, 279, 333, 280, 279, 280, 
	334, 279, 335, 280, 279, 336, 280, 279, 
	280, 337, 279, 280, 338, 279, 280, 339, 
	279, 280, 340, 279, 341, 280, 279, 342, 
	280, 279, 343, 280, 279, 304, 280, 279, 
	280, 345, 279, 346, 280, 279, 347, 280, 
	279, 280, 348, 279, 349, 280, 279, 350, 
	280, 279, 280, 351, 279, 280, 352, 279, 
	280, 330, 279, 354, 0, 355, 0, 30, 
	0, 357, 0, 358, 450, 0, 359, 0, 
	360, 0, 361, 0, 362, 0, 363, 0, 
	364, 0, 365, 0, 366, 0, 367, 0, 
	369, 368, 369, 368, 369, 369, 4, 370, 
	384, 4, 385, 384, 387, 393, 398, 401, 
	428, 444, 369, 368, 369, 371, 368, 369, 
	372, 368, 369, 373, 368, 369, 374, 368, 
	369, 375, 368, 369, 376, 368, 369, 377, 
	368, 369, 378, 368, 369, 379, 368, 369, 
	380, 368, 369, 381, 368, 369, 382, 368, 
	369, 383, 368, 369, 4, 368, 369, 79, 
	368, 369, 386, 368, 369, 384, 368, 369, 
	388, 368, 389, 369, 368, 390, 392, 369, 
	368, 369, 391, 368, 369, 384, 368, 369, 
	390, 368, 369, 394, 368, 369, 395, 368, 
	396, 369, 368, 397, 369, 368, 369, 384, 
	368, 369, 399, 368, 369, 400, 368, 369, 
	384, 368, 369, 402, 411, 368, 369, 403, 
	368, 369, 404, 368, 369, 405, 368, 369, 
	406, 368, 369, 407, 368, 369, 408, 368, 
	369, 409, 368, 369, 410, 368, 369, 79, 
	368, 369, 412, 368, 369, 413, 368, 369, 
	414, 368, 369, 415, 368, 369, 416, 368, 
	369, 417, 368, 369, 418, 368, 369, 419, 
	368, 369, 420, 368, 369, 421, 368, 369, 
	422, 368, 369, 423, 368, 369, 424, 368, 
	369, 425, 368, 369, 426, 368, 369, 427, 
	368, 369, 410, 368, 429, 369, 441, 368, 
	430, 369, 368, 369, 431, 368, 432, 369, 
	368, 433, 369, 368, 369, 434, 368, 369, 
	435, 368, 369, 436, 368, 369, 437, 368, 
	438, 369, 368, 439, 369, 368, 440, 369, 
	368, 410, 369, 368, 369, 442, 368, 369, 
	443, 368, 369, 384, 368, 369, 445, 368, 
	369, 446, 368, 447, 369, 368, 448, 369, 
	368, 369, 449, 368, 369, 393, 368, 451, 
	0, 452, 0, 453, 0, 44, 0, 454, 
	455, 454, 0, 459, 458, 457, 455, 458, 
	456, 0, 457, 455, 456, 0, 457, 456, 
	459, 458, 457, 455, 458, 456, 459, 459, 
	5, 14, 16, 30, 33, 36, 30, 38, 
	44, 49, 52, 80, 264, 356, 454, 459, 
	0, 0, 0
};

static const char _lexer_trans_actions[] = {
	0, 47, 0, 5, 1, 0, 25, 1, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 31, 0, 39, 0, 39, 0, 39, 
	47, 0, 5, 1, 0, 25, 1, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	31, 0, 39, 0, 39, 0, 39, 47, 
	0, 0, 39, 119, 41, 41, 41, 3, 
	111, 29, 29, 29, 0, 111, 29, 29, 
	29, 0, 111, 29, 0, 29, 0, 95, 
	7, 7, 39, 47, 0, 0, 39, 103, 
	21, 0, 47, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 39, 50, 99, 19, 0, 39, 
	39, 39, 39, 0, 23, 107, 23, 23, 
	44, 23, 0, 47, 0, 1, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 47, 0, 74, 77, 74, 0, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	17, 0, 115, 27, 53, 50, 27, 56, 
	50, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 59, 27, 39, 0, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 124, 50, 47, 0, 47, 0, 
	68, 29, 77, 68, 77, 77, 77, 77, 
	77, 77, 77, 77, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 13, 0, 
	47, 13, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	0, 47, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 13, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 0, 47, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 0, 47, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 124, 50, 47, 0, 47, 
	0, 71, 29, 77, 71, 77, 77, 77, 
	77, 77, 77, 77, 77, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 15, 
	0, 47, 15, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 0, 47, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 15, 0, 0, 47, 0, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 124, 50, 47, 0, 47, 
	0, 62, 29, 62, 77, 77, 77, 77, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 9, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	9, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 47, 0, 65, 29, 
	77, 65, 77, 77, 77, 77, 77, 77, 
	77, 77, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 11, 0, 47, 11, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 11, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	0, 47, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	0, 0, 39, 47, 33, 33, 80, 33, 
	33, 39, 0, 35, 0, 39, 0, 0, 
	47, 0, 0, 35, 0, 0, 47, 0, 
	86, 83, 37, 89, 83, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 92, 0, 
	39, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 460;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1073 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
    
#line 1080 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1356 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1419 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/pl.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_pl()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Pl", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

