
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 24, 25, 26, 
	27, 28, 29, 30, 32, 43, 44, 45, 
	49, 54, 59, 64, 69, 73, 77, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 90, 91, 92, 93, 94, 99, 
	106, 111, 115, 121, 124, 126, 132, 143, 
	144, 145, 146, 147, 148, 149, 150, 151, 
	152, 153, 154, 155, 156, 157, 158, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 171, 172, 173, 174, 175, 
	176, 177, 178, 179, 180, 181, 182, 189, 
	191, 193, 195, 197, 199, 201, 203, 205, 
	207, 209, 211, 213, 215, 217, 219, 221, 
	223, 225, 227, 229, 240, 241, 242, 243, 
	244, 245, 246, 247, 248, 249, 250, 251, 
	252, 253, 254, 256, 257, 258, 259, 260, 
	261, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 271, 272, 273, 274, 275, 276, 
	277, 278, 279, 280, 281, 290, 298, 300, 
	303, 305, 307, 309, 311, 313, 315, 317, 
	319, 321, 323, 325, 327, 329, 331, 333, 
	335, 337, 339, 341, 343, 345, 347, 349, 
	351, 353, 355, 357, 359, 361, 363, 365, 
	367, 369, 371, 373, 375, 377, 379, 381, 
	383, 385, 387, 389, 391, 393, 395, 397, 
	399, 401, 403, 405, 407, 409, 411, 413, 
	415, 417, 419, 421, 423, 425, 427, 429, 
	431, 433, 435, 437, 439, 441, 443, 445, 
	447, 449, 451, 453, 455, 457, 459, 460, 
	461, 470, 479, 481, 484, 486, 488, 490, 
	492, 494, 496, 498, 500, 502, 504, 506, 
	508, 510, 512, 514, 516, 518, 520, 522, 
	524, 526, 528, 530, 532, 534, 536, 538, 
	540, 542, 544, 546, 548, 550, 552, 554, 
	556, 558, 560, 562, 564, 566, 569, 571, 
	573, 575, 577, 579, 581, 583, 585, 587, 
	589, 591, 593, 595, 597, 599, 601, 603, 
	605, 607, 609, 611, 613, 615, 617, 619, 
	621, 623, 625, 627, 629, 631, 633, 635, 
	637, 639, 641, 643, 645, 647, 649, 651, 
	653, 655, 657, 659, 661, 663, 665, 667, 
	669, 671, 673, 675, 677, 679, 681, 683, 
	685, 687, 689, 691, 693, 695, 697, 699, 
	701, 703, 704, 705, 706, 707, 708, 709, 
	710, 711, 712, 713, 714, 723, 731, 733, 
	736, 738, 740, 742, 744, 746, 748, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 774, 776, 778, 780, 782, 
	784, 786, 788, 790, 792, 794, 796, 798, 
	800, 802, 804, 806, 808, 810, 812, 814, 
	816, 818, 821, 823, 825, 827, 829, 831, 
	833, 835, 837, 839, 841, 843, 845, 847, 
	849, 851, 853, 855, 857, 859, 861, 863, 
	865, 867, 869, 871, 873, 875, 877, 879, 
	881, 883, 885, 887, 889, 891, 893, 895, 
	897, 899, 901, 903, 905, 907, 909, 911, 
	913, 915, 917, 919, 921, 923, 925, 927, 
	929, 931, 933, 935, 937, 939, 940, 941, 
	942, 943, 944, 945, 946, 947, 948, 949, 
	950, 951, 952, 953, 954, 955, 956, 957, 
	958, 959, 960, 961, 962, 963, 964, 972, 
	977, 979, 981, 983, 985, 987, 989, 991, 
	993, 995, 997, 999, 1001, 1003, 1005, 1007, 
	1009, 1011, 1013, 1015, 1017, 1019, 1021, 1023, 
	1025, 1027, 1029, 1031, 1033, 1035, 1038, 1040, 
	1042, 1044, 1046, 1048, 1050, 1052, 1054, 1056, 
	1058, 1060, 1062, 1064, 1066, 1068, 1070, 1072, 
	1074, 1076, 1078, 1080, 1082, 1084, 1086, 1088, 
	1090, 1092, 1094, 1096, 1098, 1100, 1102, 1104, 
	1106, 1108, 1110, 1112, 1114, 1116, 1118, 1120, 
	1122, 1124, 1126, 1128, 1130, 1132, 1134, 1136, 
	1138, 1140, 1142, 1144, 1146, 1148, 1150, 1152, 
	1154, 1156, 1158, 1160, 1162, 1163, 1164
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -111, -110, -101, 
	-100, -95, -94, -93, -92, -48, -77, -68, 
	-48, -80, -47, -128, 32, 10, 10, 13, 
	-48, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, 34, 34, 10, 32, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 13, 32, 
	64, 9, 10, 9, 10, 13, 32, 64, 
	11, 12, 10, 32, 64, 9, 13, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, -48, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -48, 
	-68, -48, -66, -48, -72, -47, -128, -48, 
	-66, -48, -70, -48, -80, -48, -75, -48, 
	-70, -48, -72, -48, -67, -48, -72, -47, 
	-127, -48, -66, -48, -69, -48, -69, -48, 
	-80, -47, -128, 58, 10, 10, -48, 10, 
	32, 35, 124, 9, 13, -92, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -48, 
	10, -72, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, 10, 58, -48, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-47, -122, -48, -75, -48, -67, -48, -80, 
	-47, -128, -48, -72, -48, -71, 32, 58, 
	-47, -127, -47, -126, -47, -128, -47, -125, 
	-48, -70, -47, -126, -47, -125, -47, -128, 
	-48, -80, -47, -127, -48, -72, 58, 10, 
	10, -48, 10, 32, 35, 37, 42, 64, 
	9, 13, -112, -111, -110, -101, -95, -93, 
	-92, 10, -48, 10, -77, -68, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, 10, 
	32, -48, 10, -68, 10, -48, 10, -66, 
	10, -48, 10, -72, 10, -47, 10, -128, 
	10, -48, 10, -66, 10, -48, 10, -70, 
	10, -48, 10, -80, 10, -48, 10, -75, 
	10, -48, 10, -70, 10, -48, 10, -72, 
	10, -48, 10, -67, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, 10, 58, -48, 10, -67, 10, -48, 
	10, -76, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 10, -48, 10, 32, 
	35, 37, 42, 64, 9, 13, -112, -111, 
	-110, -101, -95, -94, -93, -92, 10, -48, 
	10, -77, -68, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, 10, 32, -48, 10, 
	-68, 10, -48, 10, -66, 10, -48, 10, 
	-72, 10, -47, 10, -128, 10, -48, 10, 
	-66, 10, -48, 10, -70, 10, -48, 10, 
	-80, 10, -48, 10, -75, 10, -48, 10, 
	-70, 10, -48, 10, -72, 10, -48, 10, 
	-67, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, 10, -71, 10, 10, 32, 
	58, -47, 10, -127, 10, -47, 10, -126, 
	10, -47, 10, -128, 10, -47, 10, -125, 
	10, -48, 10, -70, 10, -47, 10, -126, 
	10, -47, 10, -125, 10, -47, 10, -128, 
	10, -48, 10, -80, 10, -47, 10, -127, 
	10, -48, 10, -72, 10, 10, 58, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -123, 10, -48, 
	10, -67, 10, -48, 10, -76, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -48, 
	10, -72, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -48, 
	-80, -47, -128, -48, -72, -47, -123, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -111, -110, -101, -95, 
	-93, -92, 10, -48, 10, -77, -68, 10, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	10, 32, -48, 10, -68, 10, -48, 10, 
	-66, 10, -48, 10, -72, 10, -47, 10, 
	-128, 10, -48, 10, -66, 10, -48, 10, 
	-70, 10, -48, 10, -80, 10, -48, 10, 
	-75, 10, -48, 10, -70, 10, -48, 10, 
	-72, 10, -48, 10, -67, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, 10, 32, 58, -47, 10, -127, 
	10, -47, 10, -126, 10, -47, 10, -128, 
	10, -47, 10, -125, 10, -48, 10, -70, 
	10, -47, 10, -126, 10, -47, 10, -125, 
	10, -47, 10, -128, 10, -48, 10, -80, 
	10, -47, 10, -127, 10, -48, 10, -72, 
	10, 10, 58, -48, 10, -67, 10, -48, 
	10, -76, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -67, -48, -76, -47, 
	-125, -48, -67, -48, -70, -47, -122, -48, 
	-72, -48, -66, -48, -67, -48, -80, -48, 
	-69, 58, 10, 10, -48, 10, 32, 35, 
	37, 64, 9, 13, -100, -95, -94, -92, 
	10, -48, 10, -72, 10, -47, 10, -127, 
	10, -48, 10, -66, 10, -48, 10, -69, 
	10, -48, 10, -69, 10, -48, 10, -80, 
	10, -47, 10, -128, 10, 10, 58, -47, 
	10, -122, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -71, 10, 10, 32, 58, -47, 10, 
	-127, 10, -47, 10, -126, 10, -47, 10, 
	-128, 10, -47, 10, -125, 10, -48, 10, 
	-70, 10, -47, 10, -126, 10, -47, 10, 
	-125, 10, -47, 10, -128, 10, -48, 10, 
	-80, 10, -47, 10, -127, 10, -48, 10, 
	-72, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -47, 10, 
	-123, 10, -47, 10, -125, 10, -48, 10, 
	-67, 10, -48, 10, -70, 10, -47, 10, 
	-122, 10, -48, 10, -72, 10, -48, 10, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -69, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 2, 1, 1, 1, 
	1, 1, 1, 2, 9, 1, 1, 2, 
	3, 3, 3, 3, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 3, 5, 
	3, 2, 4, 3, 2, 4, 9, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 5, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 8, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	7, 9, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 8, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 6, 5, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 0, 0, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 27, 29, 31, 
	33, 35, 37, 39, 42, 53, 55, 57, 
	61, 66, 71, 76, 81, 85, 89, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 112, 114, 116, 118, 120, 122, 127, 
	134, 139, 143, 149, 153, 156, 162, 173, 
	175, 177, 179, 181, 183, 185, 187, 189, 
	191, 193, 195, 197, 199, 201, 203, 205, 
	207, 209, 211, 213, 215, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 237, 
	239, 241, 243, 245, 247, 249, 251, 258, 
	261, 264, 267, 270, 273, 276, 279, 282, 
	285, 288, 291, 294, 297, 300, 303, 306, 
	309, 312, 315, 318, 329, 331, 333, 335, 
	337, 339, 341, 343, 345, 347, 349, 351, 
	353, 355, 357, 360, 362, 364, 366, 368, 
	370, 372, 374, 376, 378, 380, 382, 384, 
	386, 388, 390, 392, 394, 396, 398, 400, 
	402, 404, 406, 408, 410, 419, 428, 431, 
	435, 438, 441, 444, 447, 450, 453, 456, 
	459, 462, 465, 468, 471, 474, 477, 480, 
	483, 486, 489, 492, 495, 498, 501, 504, 
	507, 510, 513, 516, 519, 522, 525, 528, 
	531, 534, 537, 540, 543, 546, 549, 552, 
	555, 558, 561, 564, 567, 570, 573, 576, 
	579, 582, 585, 588, 591, 594, 597, 600, 
	603, 606, 609, 612, 615, 618, 621, 624, 
	627, 630, 633, 636, 639, 642, 645, 648, 
	651, 654, 657, 660, 663, 666, 669, 671, 
	673, 682, 692, 695, 699, 702, 705, 708, 
	711, 714, 717, 720, 723, 726, 729, 732, 
	735, 738, 741, 744, 747, 750, 753, 756, 
	759, 762, 765, 768, 771, 774, 777, 780, 
	783, 786, 789, 792, 795, 798, 801, 804, 
	807, 810, 813, 816, 819, 822, 826, 829, 
	832, 835, 838, 841, 844, 847, 850, 853, 
	856, 859, 862, 865, 868, 871, 874, 877, 
	880, 883, 886, 889, 892, 895, 898, 901, 
	904, 907, 910, 913, 916, 919, 922, 925, 
	928, 931, 934, 937, 940, 943, 946, 949, 
	952, 955, 958, 961, 964, 967, 970, 973, 
	976, 979, 982, 985, 988, 991, 994, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1029, 1031, 1033, 1035, 1037, 1039, 
	1041, 1043, 1045, 1047, 1049, 1058, 1067, 1070, 
	1074, 1077, 1080, 1083, 1086, 1089, 1092, 1095, 
	1098, 1101, 1104, 1107, 1110, 1113, 1116, 1119, 
	1122, 1125, 1128, 1131, 1134, 1137, 1140, 1143, 
	1146, 1149, 1152, 1155, 1158, 1161, 1164, 1167, 
	1170, 1173, 1176, 1179, 1182, 1185, 1188, 1191, 
	1194, 1197, 1201, 1204, 1207, 1210, 1213, 1216, 
	1219, 1222, 1225, 1228, 1231, 1234, 1237, 1240, 
	1243, 1246, 1249, 1252, 1255, 1258, 1261, 1264, 
	1267, 1270, 1273, 1276, 1279, 1282, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1306, 1309, 1312, 
	1315, 1318, 1321, 1324, 1327, 1330, 1333, 1336, 
	1339, 1342, 1345, 1348, 1351, 1354, 1357, 1360, 
	1363, 1366, 1369, 1372, 1375, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1392, 1394, 1396, 1398, 
	1400, 1402, 1404, 1406, 1408, 1410, 1412, 1414, 
	1416, 1418, 1420, 1422, 1424, 1426, 1428, 1436, 
	1442, 1445, 1448, 1451, 1454, 1457, 1460, 1463, 
	1466, 1469, 1472, 1475, 1478, 1481, 1484, 1487, 
	1490, 1493, 1496, 1499, 1502, 1505, 1508, 1511, 
	1514, 1517, 1520, 1523, 1526, 1529, 1533, 1536, 
	1539, 1542, 1545, 1548, 1551, 1554, 1557, 1560, 
	1563, 1566, 1569, 1572, 1575, 1578, 1581, 1584, 
	1587, 1590, 1593, 1596, 1599, 1602, 1605, 1608, 
	1611, 1614, 1617, 1620, 1623, 1626, 1629, 1632, 
	1635, 1638, 1641, 1644, 1647, 1650, 1653, 1656, 
	1659, 1662, 1665, 1668, 1671, 1674, 1677, 1680, 
	1683, 1686, 1689, 1692, 1695, 1698, 1701, 1704, 
	1707, 1710, 1713, 1716, 1719, 1721, 1723
};

static const short _lexer_trans_targs[] = {
	2, 580, 12, 12, 13, 22, 24, 9, 
	38, 41, 12, 0, 3, 51, 59, 61, 
	69, 108, 345, 461, 465, 0, 4, 0, 
	5, 47, 0, 6, 0, 7, 0, 8, 
	0, 9, 0, 10, 0, 0, 11, 12, 
	23, 11, 2, 12, 12, 13, 22, 24, 
	9, 38, 41, 12, 0, 14, 0, 15, 
	0, 16, 15, 15, 0, 17, 17, 18, 
	17, 17, 17, 17, 18, 17, 17, 17, 
	17, 19, 17, 17, 17, 17, 20, 17, 
	17, 12, 21, 21, 0, 12, 21, 21, 
	0, 12, 23, 22, 12, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 37, 0, 
	582, 0, 0, 0, 0, 0, 39, 40, 
	12, 40, 40, 38, 39, 39, 12, 40, 
	38, 40, 0, 41, 42, 41, 0, 46, 
	45, 44, 42, 45, 43, 0, 44, 42, 
	43, 0, 44, 43, 46, 45, 44, 42, 
	45, 43, 2, 46, 46, 13, 22, 24, 
	9, 38, 41, 46, 0, 48, 0, 49, 
	0, 50, 0, 9, 0, 52, 0, 53, 
	0, 54, 0, 55, 0, 56, 0, 57, 
	0, 58, 0, 9, 0, 60, 0, 9, 
	0, 62, 0, 63, 0, 64, 0, 65, 
	0, 66, 0, 67, 0, 68, 0, 9, 
	0, 70, 0, 71, 0, 72, 0, 73, 
	0, 74, 0, 75, 0, 76, 0, 77, 
	0, 78, 0, 79, 0, 80, 0, 81, 
	0, 82, 0, 83, 0, 84, 0, 86, 
	85, 86, 85, 87, 86, 86, 12, 12, 
	86, 85, 88, 86, 85, 89, 86, 85, 
	90, 86, 85, 91, 86, 85, 92, 86, 
	85, 93, 86, 85, 94, 86, 85, 95, 
	86, 85, 96, 86, 85, 97, 86, 85, 
	98, 86, 85, 99, 86, 85, 100, 86, 
	85, 101, 86, 85, 102, 86, 85, 103, 
	86, 85, 104, 86, 85, 105, 86, 85, 
	106, 86, 85, 86, 107, 85, 2, 12, 
	12, 13, 22, 24, 9, 38, 41, 12, 
	0, 109, 0, 110, 0, 111, 0, 112, 
	0, 113, 0, 114, 0, 115, 0, 116, 
	0, 117, 0, 118, 0, 119, 0, 120, 
	0, 121, 0, 122, 0, 123, 230, 0, 
	124, 0, 125, 0, 126, 0, 127, 0, 
	128, 0, 129, 0, 130, 0, 131, 0, 
	132, 0, 133, 0, 134, 0, 135, 0, 
	136, 0, 137, 0, 138, 0, 139, 0, 
	140, 0, 141, 0, 142, 0, 143, 0, 
	144, 0, 145, 0, 146, 0, 148, 147, 
	148, 147, 149, 148, 148, 12, 216, 156, 
	12, 148, 147, 150, 161, 169, 171, 179, 
	194, 198, 148, 147, 151, 148, 147, 152, 
	157, 148, 147, 153, 148, 147, 154, 148, 
	147, 155, 148, 147, 156, 148, 147, 148, 
	107, 147, 158, 148, 147, 159, 148, 147, 
	160, 148, 147, 156, 148, 147, 162, 148, 
	147, 163, 148, 147, 164, 148, 147, 165, 
	148, 147, 166, 148, 147, 167, 148, 147, 
	168, 148, 147, 156, 148, 147, 170, 148, 
	147, 156, 148, 147, 172, 148, 147, 173, 
	148, 147, 174, 148, 147, 175, 148, 147, 
	176, 148, 147, 177, 148, 147, 178, 148, 
	147, 156, 148, 147, 180, 148, 147, 181, 
	148, 147, 182, 148, 147, 183, 148, 147, 
	184, 148, 147, 185, 148, 147, 186, 148, 
	147, 187, 148, 147, 188, 148, 147, 189, 
	148, 147, 190, 148, 147, 191, 148, 147, 
	192, 148, 147, 193, 148, 147, 148, 107, 
	147, 195, 148, 147, 196, 148, 147, 197, 
	148, 147, 169, 148, 147, 199, 148, 147, 
	200, 148, 147, 201, 148, 147, 202, 148, 
	147, 203, 148, 147, 204, 148, 147, 205, 
	148, 147, 206, 148, 147, 207, 148, 147, 
	208, 148, 147, 209, 148, 147, 210, 148, 
	147, 211, 148, 147, 212, 148, 147, 213, 
	148, 147, 214, 148, 147, 215, 148, 147, 
	193, 148, 147, 148, 217, 147, 148, 218, 
	147, 148, 219, 147, 148, 220, 147, 148, 
	221, 147, 148, 222, 147, 148, 223, 147, 
	148, 224, 147, 148, 225, 147, 148, 226, 
	147, 148, 227, 147, 148, 228, 147, 148, 
	229, 147, 148, 12, 147, 232, 231, 232, 
	231, 233, 232, 232, 12, 331, 240, 12, 
	232, 231, 234, 245, 253, 255, 263, 301, 
	309, 313, 232, 231, 235, 232, 231, 236, 
	241, 232, 231, 237, 232, 231, 238, 232, 
	231, 239, 232, 231, 240, 232, 231, 232, 
	107, 231, 242, 232, 231, 243, 232, 231, 
	244, 232, 231, 240, 232, 231, 246, 232, 
	231, 247, 232, 231, 248, 232, 231, 249, 
	232, 231, 250, 232, 231, 251, 232, 231, 
	252, 232, 231, 240, 232, 231, 254, 232, 
	231, 240, 232, 231, 256, 232, 231, 257, 
	232, 231, 258, 232, 231, 259, 232, 231, 
	260, 232, 231, 261, 232, 231, 262, 232, 
	231, 240, 232, 231, 264, 232, 231, 265, 
	232, 231, 266, 232, 231, 267, 232, 231, 
	268, 232, 231, 269, 232, 231, 270, 232, 
	231, 271, 232, 231, 272, 232, 231, 273, 
	232, 231, 274, 232, 231, 275, 232, 231, 
	276, 232, 231, 277, 232, 231, 232, 278, 
	107, 231, 279, 232, 231, 280, 232, 231, 
	281, 232, 231, 282, 232, 231, 283, 232, 
	231, 284, 232, 231, 285, 232, 231, 286, 
	232, 231, 287, 232, 231, 288, 232, 231, 
	289, 232, 231, 290, 232, 231, 291, 232, 
	231, 292, 232, 231, 293, 232, 231, 294, 
	232, 231, 295, 232, 231, 296, 232, 231, 
	297, 232, 231, 298, 232, 231, 299, 232, 
	231, 300, 232, 231, 232, 107, 231, 302, 
	232, 231, 303, 232, 231, 304, 232, 231, 
	305, 232, 231, 306, 232, 231, 307, 232, 
	231, 308, 232, 231, 300, 232, 231, 310, 
	232, 231, 311, 232, 231, 312, 232, 231, 
	253, 232, 231, 314, 232, 231, 315, 232, 
	231, 316, 232, 231, 317, 232, 231, 318, 
	232, 231, 319, 232, 231, 320, 232, 231, 
	321, 232, 231, 322, 232, 231, 323, 232, 
	231, 324, 232, 231, 325, 232, 231, 326, 
	232, 231, 327, 232, 231, 328, 232, 231, 
	329, 232, 231, 330, 232, 231, 300, 232, 
	231, 232, 332, 231, 232, 333, 231, 232, 
	334, 231, 232, 335, 231, 232, 336, 231, 
	232, 337, 231, 232, 338, 231, 232, 339, 
	231, 232, 340, 231, 232, 341, 231, 232, 
	342, 231, 232, 343, 231, 232, 344, 231, 
	232, 12, 231, 346, 0, 347, 0, 348, 
	0, 349, 0, 350, 0, 351, 0, 352, 
	0, 353, 0, 354, 0, 356, 355, 356, 
	355, 357, 356, 356, 12, 447, 364, 12, 
	356, 355, 358, 369, 377, 379, 387, 425, 
	429, 356, 355, 359, 356, 355, 360, 365, 
	356, 355, 361, 356, 355, 362, 356, 355, 
	363, 356, 355, 364, 356, 355, 356, 107, 
	355, 366, 356, 355, 367, 356, 355, 368, 
	356, 355, 364, 356, 355, 370, 356, 355, 
	371, 356, 355, 372, 356, 355, 373, 356, 
	355, 374, 356, 355, 375, 356, 355, 376, 
	356, 355, 364, 356, 355, 378, 356, 355, 
	364, 356, 355, 380, 356, 355, 381, 356, 
	355, 382, 356, 355, 383, 356, 355, 384, 
	356, 355, 385, 356, 355, 386, 356, 355, 
	364, 356, 355, 388, 356, 355, 389, 356, 
	355, 390, 356, 355, 391, 356, 355, 392, 
	356, 355, 393, 356, 355, 394, 356, 355, 
	395, 356, 355, 396, 356, 355, 397, 356, 
	355, 398, 356, 355, 399, 356, 355, 400, 
	356, 355, 401, 356, 355, 356, 402, 107, 
	355, 403, 356, 355, 404, 356, 355, 405, 
	356, 355, 406, 356, 355, 407, 356, 355, 
	408, 356, 355, 409, 356, 355, 410, 356, 
	355, 411, 356, 355, 412, 356, 355, 413, 
	356, 355, 414, 356, 355, 415, 356, 355, 
	416, 356, 355, 417, 356, 355, 418, 356, 
	355, 419, 356, 355, 420, 356, 355, 421, 
	356, 355, 422, 356, 355, 423, 356, 355, 
	424, 356, 355, 356, 107, 355, 426, 356, 
	355, 427, 356, 355, 428, 356, 355, 377, 
	356, 355, 430, 356, 355, 431, 356, 355, 
	432, 356, 355, 433, 356, 355, 434, 356, 
	355, 435, 356, 355, 436, 356, 355, 437, 
	356, 355, 438, 356, 355, 439, 356, 355, 
	440, 356, 355, 441, 356, 355, 442, 356, 
	355, 443, 356, 355, 444, 356, 355, 445, 
	356, 355, 446, 356, 355, 424, 356, 355, 
	356, 448, 355, 356, 449, 355, 356, 450, 
	355, 356, 451, 355, 356, 452, 355, 356, 
	453, 355, 356, 454, 355, 356, 455, 355, 
	356, 456, 355, 356, 457, 355, 356, 458, 
	355, 356, 459, 355, 356, 460, 355, 356, 
	12, 355, 462, 0, 463, 0, 464, 0, 
	59, 0, 466, 0, 467, 0, 468, 0, 
	469, 0, 470, 0, 471, 0, 472, 0, 
	473, 0, 474, 0, 475, 0, 476, 0, 
	477, 0, 478, 0, 479, 0, 480, 0, 
	481, 0, 482, 0, 483, 0, 484, 0, 
	486, 485, 486, 485, 487, 486, 486, 12, 
	566, 12, 486, 485, 488, 503, 540, 548, 
	486, 485, 489, 486, 485, 490, 486, 485, 
	491, 486, 485, 492, 486, 485, 493, 486, 
	485, 494, 486, 485, 495, 486, 485, 496, 
	486, 485, 497, 486, 485, 498, 486, 485, 
	499, 486, 485, 500, 486, 485, 501, 486, 
	485, 502, 486, 485, 486, 107, 485, 504, 
	486, 485, 505, 486, 485, 506, 486, 485, 
	507, 486, 485, 508, 486, 485, 509, 486, 
	485, 510, 486, 485, 511, 486, 485, 512, 
	486, 485, 513, 486, 485, 514, 486, 485, 
	515, 486, 485, 516, 486, 485, 517, 486, 
	485, 486, 518, 107, 485, 519, 486, 485, 
	520, 486, 485, 521, 486, 485, 522, 486, 
	485, 523, 486, 485, 524, 486, 485, 525, 
	486, 485, 526, 486, 485, 527, 486, 485, 
	528, 486, 485, 529, 486, 485, 530, 486, 
	485, 531, 486, 485, 532, 486, 485, 533, 
	486, 485, 534, 486, 485, 535, 486, 485, 
	536, 486, 485, 537, 486, 485, 538, 486, 
	485, 539, 486, 485, 502, 486, 485, 541, 
	486, 485, 542, 486, 485, 543, 486, 485, 
	544, 486, 485, 545, 486, 485, 546, 486, 
	485, 547, 486, 485, 502, 486, 485, 549, 
	486, 485, 550, 486, 485, 551, 486, 485, 
	552, 486, 485, 553, 486, 485, 554, 486, 
	485, 555, 486, 485, 556, 486, 485, 557, 
	486, 485, 558, 486, 485, 559, 486, 485, 
	560, 486, 485, 561, 486, 485, 562, 486, 
	485, 563, 486, 485, 564, 486, 485, 565, 
	486, 485, 502, 486, 485, 486, 567, 485, 
	486, 568, 485, 486, 569, 485, 486, 570, 
	485, 486, 571, 485, 486, 572, 485, 486, 
	573, 485, 486, 574, 485, 486, 575, 485, 
	486, 576, 485, 486, 577, 485, 486, 578, 
	485, 486, 579, 485, 486, 12, 485, 581, 
	0, 12, 0, 0, 0
};

static const char _lexer_trans_actions[] = {
	25, 0, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 39, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 39, 50, 99, 
	19, 0, 25, 47, 0, 5, 1, 0, 
	25, 1, 31, 0, 39, 0, 39, 0, 
	39, 47, 0, 0, 39, 119, 41, 41, 
	41, 3, 111, 29, 29, 29, 0, 111, 
	29, 29, 29, 0, 111, 29, 0, 29, 
	0, 95, 7, 7, 39, 47, 0, 0, 
	39, 103, 21, 0, 47, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 39, 39, 39, 39, 0, 23, 
	107, 23, 23, 44, 23, 0, 47, 0, 
	1, 0, 39, 0, 0, 0, 39, 47, 
	33, 33, 80, 33, 33, 39, 0, 35, 
	0, 39, 0, 0, 47, 0, 0, 35, 
	0, 0, 89, 47, 0, 86, 83, 37, 
	89, 83, 92, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 74, 74, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 17, 0, 56, 115, 
	27, 53, 50, 27, 56, 50, 59, 27, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 124, 50, 
	47, 0, 77, 47, 0, 71, 29, 77, 
	71, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	15, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 15, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 15, 0, 124, 50, 47, 
	0, 77, 47, 0, 68, 29, 77, 68, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	13, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	13, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 13, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 13, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 77, 47, 0, 65, 29, 77, 65, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 11, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 0, 11, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 11, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	11, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 77, 47, 0, 62, 
	29, 62, 0, 0, 0, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 9, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 9, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 9, 0, 0, 
	39, 0, 39, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 582;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1247 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
    
#line 1254 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1530 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1593 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uz.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_uz()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Uz", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

