#include <vector>
#include <string>
#include <algorithm>
#include <fstream>
#include <iostream>
#include "contrast.h"

#include <rumba/arghandler.h>
#include <rumba/matrixio.h>

using namespace RUMBA;
using namespace std;

std::string usage()
{
	return "test-contrasts -i infile [--header-row n] --contrast contrast_string -m multiplicity";
}

Argument myArgs[] =
{
	Argument("header-row", RUMBA::NUMERIC, '\0', 1),
	Argument("contrast", RUMBA::ALPHA, 'c', "", true, true),
	Argument("contrast-file", RUMBA::ALPHA, 'f', "" ),
	Argument("acquisitions-per-trial", RUMBA::NUMERIC, 'a', 1 ),
	Argument()
};


int main(int argc, char** argv)
{
	RUMBA::ArgHandler argh(argc,argv, myArgs);
	RUMBA::Log log ("main");
	std::string infile;
	std::string s;
	std::string outfile;
	std::string cfile;
	int multiplicity;
	vector<Splodge> contrasts;

	int header_row = 1;
	int count = 1;
	vector<string> headers;

	try {
		argh.arg("infile",infile);
		argh.arg("header-row",header_row);
		argh.arg("outfile",outfile);
		argh.arg("contrast-file",cfile);
		argh.arg("acquisitions-per-trial",multiplicity);

		contrasts = argh.multiarg("contrast");
		std::ifstream fin(infile.c_str());
		if (!fin)
		{
			std::cerr << "Couldn't open file " << infile << std::endl;
			exit(1);
		}


		do 
		{ 
			getline(fin,s);
			count++;
		}while (count < header_row);

		if (!fin)
		{
			std::cerr << "Couldn't skip to header row " << header_row << std::endl;
			exit(1);
		}


		headers = argh.loose();
		vector<Factor> factors;


		process_header(factors, s, headers);
		while ( getline(fin,s))
			process_row(factors,s);
		
	fin.clear();
	fin.seekg(0,std::ios::beg);

	count = 1;
	// skip leading garbage 
	do 
	{ 
		getline(fin,s);
		count++;
	}while (count < header_row);

	ManifoldMatrix DM (design_matrix( fin, factors ));
	DM = repeatRows(DM, multiplicity);
	manifoldMatrixWriteHack (DM, outfile);


	/*
		std::copy(factors.begin(),factors.end(), 
			std::ostream_iterator<Factor>(cout, "\n"));
	*/

//		std::map<Treatment,double> set1,set2;

		if ( !cfile.empty() )	
		{
			manifold_generator g;
			ManifoldMatrix M = g(contrasts.size(), count_treatments(factors));
			for ( unsigned int i = 0; i < contrasts.size(); ++i )
			{
				log.logName() << "Command is :" 
					<< contrasts[i].asString() << "\n";
				Parser p(factors,contrasts[i].asString());
				M.put( i,0, (generateContrast(p.parse(),factors)));
			}
			manifoldMatrixWriteHack (M, cfile );
		}


	} catch(RUMBA::Exception& e)
	{
		std::cerr << e.error() << std::endl;
	}

//	while ( getline(fin,s)) process_row(factors,s);
	
}

