#ifndef RUMBA_CONTRAST_H
#define RUMBA_CONTRAST_H

#include "design.h"

#include <set>
#include <algorithm>
#include <vector>


// void parse_set ( std::map<Treatment,double>& s, const std::string & command, std::vector<Factor>& factors );

void test_parse_set 
(const std::string & command , std::vector<Factor>& factors);

RUMBA::ManifoldMatrix generateContrast ( 
		const std::map<Treatment,double>& s, 
		const std::vector<Factor>& factors
		);

enum token_type_t  { 
	TOKEN_AND, 
	TOKEN_OR, 
	TOKEN_NOT, 
	TOKEN_VERSUS, 
	TOKEN_FACTOR 
}; 


class Parser
{
public:
	Parser ( const std::vector<Factor>& factors, const std::string& s);
	Parser
	( 
	 const std::vector<Factor>& factors, 
	 std::vector<std::string> tokens,
	 std::vector<int> token_types ,
	 double weight =1
	 );

	const std::map<Treatment,double>& parse();
	
//	void parse_set ( std::map<Treatment,double>& s, const std::string & command);
private:
	const std::vector<Factor>& factors;
	std::string parse_string;
	bool invert;
	int op;
	double weight;
	std::vector<int> token_types;
	std::vector<std::string> tokens;
	std::map<Treatment,double>  current;

	bool validate() const; // check token_types to make sure we're well formed

	void init_token_types();

	void process( 
			const std::map<Treatment,double>& , 
			bool invert, 
			int op, 
			const std::string& tok
	);

	void process_versus(int start);
	static void normalize_weights(std::map<Treatment,double>& s);
	static double sum_weights(const std::map<Treatment,double>& s);


};

class factor_token_handler 
{
public:
	factor_token_handler 
	(const std::string& token, const std::vector<Factor>& factors, double);
	void parse ( std::map<Treatment,double> & );
	void parse 
	( 
	 const std::map<Treatment,double>& lhs, 
	 std::map<Treatment,double>& s, 
	 int op, 
	 bool invert_rhs
	 );
private:
	std::string token;
	int factor_index;
	std::vector<std::string> levels;
	const std::vector<Factor>& factors;
	double weight;

};


#endif
