#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>
#include <rumba/log.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: matrix-identity --rows r -o outfile\n";
}

Argument myArgs [] = {
	Argument ( "rows", RUMBA::NUMERIC, 'r', RUMBA::Splodge(1), false ),
	Argument()
};

int main(int argc,char** argv)
{
	std::string outfile;
	double r;

	RUMBA::Log log("MAIN ");
	
	try {
		ArgHandler argh ( argc , argv , myArgs);
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		try{ argh.arg ( "outfile" , outfile ); } catch(...){}
		argh.arg("rows", r);
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

	log.logName()<< "r = "<<r<<"\n";
	manifoldMatrixWriteHack( 
			identityMatrix(static_cast<int>(r)) , outfile.c_str() );
}
