#include <gauss.h>
#include <rumba/manifold.h>

double Z_MIN = -5.5;
double Z_MAX = 5.5;

int main()
{
	double steps = 10000;
	RUMBA::Manifold<double> x(RUMBA::intPoint(steps,1,1,1));
	x.headerData()["validMin"] = (-5.5);
	x.headerData()["validMax"] = (5.5);

	double incr = (Z_MAX - Z_MIN)/steps;
	double z = Z_MIN;
	for ( int i = 0; i < steps; ++i, z+=incr )
		x[i] = Gauss::integral_gauss ( z );
		
	x.save ("table.hdr");	

}
