#include "../matrixutils/mask.h"
#include <rumba/arghandler.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: threshold-mask -i infile -o outfile \n"
		"[[-u|--upper]  n1] [[-l|--lower] n2]\n"
		<< std::endl;
}


Argument myArgs [] = {
	Argument( "lower", RUMBA::NUMERIC, 'l', RUMBA::Splodge(), false ),
	Argument( "upper", RUMBA::NUMERIC, 'u', RUMBA::Splodge(), false ),
	Argument()
};


int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	double upper=0,lower=0;
	bool have_lower=true, have_upper=true;
	std::string infile,outfile;
	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );

		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		argh.arg("infile",infile);
		argh.arg("outfile",outfile);

		if (argh.arg ("upper")) 
			argh.arg("upper",upper);
		else
			have_upper = false;  
			
		if (argh.arg ("lower"))
		   argh.arg("lower",lower);
		else
			have_lower = false;

		if ( !have_lower && !have_upper )
		{
			std::cerr << "Need to provide a max or a min" << std::endl;
			exit(1);
		}

		if ( have_lower && have_upper && lower > upper )
		{
			std::cerr << 
				"Error: lower bound exceeds upper bound" << std::endl;
			exit(1);
		}

	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}


	RUMBA::ManifoldFile* in = ManifoldFile::construct(infile.c_str());

	ThresholdMask 
		M( have_lower? &lower:0, have_upper? &upper:0);

	Manifold<char> maskman = mask(M,in);
	maskman.save(outfile.c_str());
	return 0;
}
